/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;

public class OffsetCommitRequest
extends AbstractRequest {
    public static final int DEFAULT_GENERATION_ID = -1;
    public static final String DEFAULT_MEMBER_ID = "";
    public static final long DEFAULT_RETENTION_TIME = -1L;
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final OffsetCommitRequestData data;

    public OffsetCommitRequest(OffsetCommitRequestData data, short version) {
        super(ApiKeys.OFFSET_COMMIT, version);
        this.data = data;
    }

    @Override
    public OffsetCommitRequestData data() {
        return this.data;
    }

    public Map<TopicPartition, Long> offsets() {
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        for (OffsetCommitRequestData.OffsetCommitRequestTopic topic : this.data.topics()) {
            for (OffsetCommitRequestData.OffsetCommitRequestPartition partition : topic.partitions()) {
                offsets.put(new TopicPartition(topic.name(), partition.partitionIndex()), partition.committedOffset());
            }
        }
        return offsets;
    }

    public static OffsetCommitResponseData getErrorResponse(OffsetCommitRequestData request, Errors error) {
        OffsetCommitResponseData response = new OffsetCommitResponseData();
        request.topics().forEach(topic -> {
            OffsetCommitResponseData.OffsetCommitResponseTopic responseTopic = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topic.name());
            response.topics().add(responseTopic);
            topic.partitions().forEach(partition -> responseTopic.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(error.code())));
        });
        return response;
    }

    @Override
    public OffsetCommitResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new OffsetCommitResponse(OffsetCommitRequest.getErrorResponse(this.data, Errors.forException(e)).setThrottleTimeMs(throttleTimeMs));
    }

    @Override
    public OffsetCommitResponse getErrorResponse(Throwable e) {
        return this.getErrorResponse(0, e);
    }

    public static OffsetCommitRequest parse(ByteBuffer buffer, short version) {
        return new OffsetCommitRequest(new OffsetCommitRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetCommitRequest> {
        private final OffsetCommitRequestData data;

        public Builder(OffsetCommitRequestData data) {
            super(ApiKeys.OFFSET_COMMIT);
            this.data = data;
        }

        @Override
        public OffsetCommitRequest build(short version) {
            if (this.data.groupInstanceId() != null && version < 7) {
                throw new UnsupportedVersionException("The broker offset commit protocol version " + version + " does not support usage of config group.instance.id.");
            }
            return new OffsetCommitRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

