/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.ui.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.manifoldcf.core.interfaces.BinaryInput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.TempFileInput;
import org.apache.manifoldcf.ui.beans.AdminProfile;

public class MultipartWrapper
implements IPostParameters {
    public static final String _rcsid = "@(#)$Id: MultipartWrapper.java 988245 2010-08-23 18:39:35Z kwright $";
    protected final AdminProfile adminProfile;
    protected HttpServletRequest request = null;
    protected Map variableMap = new HashMap();
    protected String characterEncoding = null;

    public MultipartWrapper(HttpServletRequest request, AdminProfile adminProfile) throws ManifoldCFException {
        if (request.getCharacterEncoding() == null) {
            try {
                request.setCharacterEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
        }
        this.adminProfile = adminProfile;
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            this.request = request;
            return;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            this.characterEncoding = request.getCharacterEncoding();
            if (this.characterEncoding == null) {
                this.characterEncoding = "utf8";
            }
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                String name = item.getFieldName();
                ArrayList<FileItem> list = (ArrayList<FileItem>)this.variableMap.get(name);
                if (list == null) {
                    list = new ArrayList<FileItem>();
                    this.variableMap.put(name, list);
                } else if (((FileItem)list.get(0)).isFormField() != item.isFormField()) {
                    throw new ManifoldCFException("Illegal form data; posted form has the same name for different data types ('" + name + "')!");
                }
                list.add(item);
            }
        }
        catch (FileUploadException e) {
            throw new ManifoldCFException("Problem uploading file: " + e.getMessage(), (Throwable)e);
        }
    }

    public String[] getParameterValues(String name) {
        ArrayList list = (ArrayList)this.variableMap.get(name);
        if (list == null) {
            if (this.request != null) {
                return this.request.getParameterValues(name);
            }
            return null;
        }
        Object x = list.get(0);
        if (x instanceof FileItem && !((FileItem)x).isFormField()) {
            return null;
        }
        String[] rval = new String[list.size()];
        for (int i = 0; i < rval.length; ++i) {
            x = list.get(i);
            if (x instanceof String) {
                rval[i] = (String)x;
                continue;
            }
            try {
                rval[i] = ((FileItem)x).getString(this.characterEncoding);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                rval[i] = ((FileItem)x).getString();
            }
        }
        return rval;
    }

    public String getParameter(String name) {
        ArrayList list = (ArrayList)this.variableMap.get(name);
        if (list == null) {
            if (this.request != null) {
                return this.request.getParameter(name);
            }
            return null;
        }
        Object x = list.get(0);
        if (x instanceof String) {
            return (String)x;
        }
        FileItem item = (FileItem)x;
        if (!item.isFormField()) {
            return null;
        }
        try {
            return item.getString(this.characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return item.getString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryInput getBinaryStream(String name) throws ManifoldCFException {
        TempFileInput tempFileInput;
        if (this.request != null) {
            return null;
        }
        ArrayList list = (ArrayList)this.variableMap.get(name);
        if (list == null) {
            return null;
        }
        Object x = list.get(0);
        if (x instanceof String) {
            return null;
        }
        FileItem item = (FileItem)x;
        if (item.isFormField()) {
            return null;
        }
        InputStream uploadedStream = item.getInputStream();
        try {
            tempFileInput = new TempFileInput(uploadedStream);
        }
        catch (Throwable throwable) {
            try {
                uploadedStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ManifoldCFException("Error creating file binary stream", (Throwable)e);
            }
        }
        uploadedStream.close();
        return tempFileInput;
    }

    public byte[] getBinaryBytes(String name) {
        if (this.request != null) {
            return null;
        }
        ArrayList list = (ArrayList)this.variableMap.get(name);
        if (list == null) {
            return null;
        }
        Object x = list.get(0);
        if (x instanceof String) {
            return null;
        }
        FileItem item = (FileItem)x;
        if (item.isFormField()) {
            return null;
        }
        return item.get();
    }

    public void setParameter(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        if (value != null) {
            values.add(value);
        }
        this.variableMap.put(name, values);
    }

    public void setParameterValues(String name, String[] values) {
        ArrayList<String> valueArray = new ArrayList<String>();
        int i = 0;
        while (i < values.length) {
            valueArray.add(values[i++]);
        }
        this.variableMap.put(name, valueArray);
    }

    public String mapPasswordToKey(String password) {
        return this.adminProfile.getPasswordMapper().mapPasswordToKey(password);
    }

    public String mapKeyToPassword(String key) {
        return this.adminProfile.getPasswordMapper().mapKeyToPassword(key);
    }
}

