/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.GO_Integer;
import org.apache.sis.internal.jaxb.gco.GO_UnlimitedInteger;
import org.apache.sis.internal.jaxb.gco.UnlimitedInteger;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.xml.NilReason;

@XmlType(name="MultiplicityRange_Type", propOrder={"lower", "upper"})
final class MultiplicityRange {
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=GO_Integer.class)
    private Integer lower;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=GO_UnlimitedInteger.class)
    private UnlimitedInteger upper;

    private MultiplicityRange() {
    }

    private MultiplicityRange(NumberRange<Integer> numberRange) {
        if (numberRange != null) {
            this.lower = (Integer)numberRange.getMinValue();
            if (this.lower == null) {
                this.lower = NilReason.UNKNOWN.createNilObject(Integer.class);
            } else if (!numberRange.isMinIncluded()) {
                this.lower = Math.incrementExact(this.lower);
            }
            this.upper = new UnlimitedInteger((Integer)numberRange.getMaxValue(), numberRange.isMaxIncluded());
        } else {
            this.lower = 0;
            this.upper = new UnlimitedInteger();
        }
    }

    static MultiplicityRange wrap(NumberRange<Integer> numberRange) {
        return numberRange != null ? new MultiplicityRange(numberRange) : null;
    }

    NumberRange<Integer> value() {
        Integer n;
        if (this.lower != null && this.upper != null && ((n = this.upper.value()) != null || this.upper.isInfinite())) {
            return new NumberRange<Integer>(Integer.class, this.lower, true, n, true);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.value());
    }
}

