/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ir.sentiment.analysis.cmdline;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Logger;
import opennlp.tools.cmdline.BasicCmdLineTool;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TikaTool
extends BasicCmdLineTool {
    private static final Logger LOG = Logger.getLogger(TikaTool.class.getName());
    private static final String DEFAULT_MODEL = "en-sentiment.bin";
    private Parser parser;
    private String encoding = null;
    private Detector detector = new DefaultDetector();
    private ParseContext context;
    private String url;

    public TikaTool() {
        this.parser = new AutoDetectParser(this.detector);
        this.context = new ParseContext();
        this.context.set(Parser.class, (Object)this.parser);
    }

    private static Writer getOutputWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            return new OutputStreamWriter(output, encoding);
        }
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).startsWith("mac os x")) {
            return new OutputStreamWriter(output, StandardCharsets.UTF_8);
        }
        return new OutputStreamWriter(output, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String fileName, String model) throws MalformedURLException {
        File file = new File(fileName);
        URL url = file.isFile() ? file.toURI().toURL() : new URL(fileName);
        Metadata metadata = new Metadata();
        metadata.add("model", model);
        try (TikaInputStream input = TikaInputStream.get((URL)url, (Metadata)metadata);){
            this.process((InputStream)input, System.out, metadata);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (TikaException e) {
            e.printStackTrace();
        }
        finally {
            System.out.flush();
        }
    }

    public void process(InputStream input, OutputStream output, Metadata metadata) throws IOException, SAXException, TikaException {
        Parser p = this.parser;
        PrintWriter writer = new PrintWriter(TikaTool.getOutputWriter(output, this.encoding));
        NoDocumentMetHandler handler = new NoDocumentMetHandler(metadata, writer);
        p.parse(input, (ContentHandler)handler, metadata, this.context);
        if (!handler.metOutput()) {
            handler.endDocument();
        }
    }

    public String getHelp() {
        return null;
    }

    public void run(String[] args) {
        String fileName = null;
        String model = DEFAULT_MODEL;
        if (args.length > 0) {
            for (int i = 0; i < args.length - 1; ++i) {
                switch (args[i]) {
                    case "-m": {
                        model = args[i + 1];
                    }
                }
            }
            fileName = args[args.length - 1];
        }
        try {
            this.process(fileName, model);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        TikaTool tool = new TikaTool();
        tool.process(args[0], args[1]);
    }

    private class NoDocumentMetHandler
    extends DefaultHandler {
        protected final Metadata metadata;
        protected PrintWriter writer;
        private boolean metOutput;

        public NoDocumentMetHandler(Metadata metadata, PrintWriter writer) {
            this.metadata = metadata;
            this.writer = writer;
            this.metOutput = false;
        }

        @Override
        public void endDocument() {
            Object[] names = this.metadata.names();
            Arrays.sort(names);
            this.outputMetadata((String[])names);
            this.writer.flush();
            this.metOutput = true;
        }

        public void outputMetadata(String[] names) {
            for (String name : names) {
                for (String value : this.metadata.getValues(name)) {
                    this.writer.println(name + ": " + value);
                }
            }
        }

        public boolean metOutput() {
            return this.metOutput;
        }
    }
}

