/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;

public class Jason2Convention
extends CoordSysBuilder {
    public static boolean isMine(NetcdfFile ncfile) {
        if (null == ncfile.findDimension("time")) {
            return false;
        }
        String center = ncfile.findAttValueIgnoreCase(null, "processing_center", null);
        if (center != null && center.equals("ESPC")) {
            String mission = ncfile.findAttValueIgnoreCase(null, "mission_name", null);
            return mission != null && mission.equals("OSTM/Jason-2");
        }
        return false;
    }

    public Jason2Convention() {
        this.conventionName = "Jason2";
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ncDataset, VariableEnhanced v) {
        String name = v.getShortName();
        if (name.equals("time")) {
            return AxisType.Time;
        }
        if (name.equals("lat")) {
            return AxisType.Lat;
        }
        if (name.equals("lon")) {
            return AxisType.Lon;
        }
        if (name.equals("alt")) {
            return AxisType.Height;
        }
        return null;
    }
}

