/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Comparator;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;

public class LogCombiner {
    private static final Comparator<LogEntry> LOG_ENTRY_TIMESTAMP_COMPARATOR = Comparator.comparingLong(LogEntry::getTimestamp);

    public static LogEntries combine(LogEntries ... entries) {
        return new LogEntries(Iterables.mergeSorted(Arrays.asList(entries), LOG_ENTRY_TIMESTAMP_COMPARATOR));
    }
}

