/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnvelopeIdResolver
extends ResourceResolverSpi {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$message$EnvelopeIdResolver == null ? (class$org$apache$ws$security$message$EnvelopeIdResolver = EnvelopeIdResolver.class$("org.apache.ws.security.message.EnvelopeIdResolver")) : class$org$apache$ws$security$message$EnvelopeIdResolver).getName());
    private static EnvelopeIdResolver resolver = null;
    private boolean doDebug = false;
    private WSDocInfo wsDocInfo;
    static /* synthetic */ Class class$org$apache$ws$security$message$EnvelopeIdResolver;

    public static synchronized ResourceResolverSpi getInstance() {
        if (resolver == null) {
            resolver = new EnvelopeIdResolver(null);
        }
        return resolver;
    }

    public EnvelopeIdResolver(WSDocInfo wsDocInfo) {
        this.wsDocInfo = wsDocInfo;
    }

    public void setWsDocInfo(WSDocInfo docInfo) {
        this.wsDocInfo = docInfo;
    }

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        this.doDebug = log.isDebugEnabled();
        String uriNodeValue = uri.getNodeValue();
        if (this.doDebug) {
            log.debug((Object)("enter engineResolve, look for: " + uriNodeValue));
        }
        Document doc = uri.getOwnerDocument();
        String id = uriNodeValue.substring(1);
        Element selectedElem = null;
        if (this.wsDocInfo != null) {
            selectedElem = this.wsDocInfo.getSecurityTokenReference(id);
        }
        if (selectedElem == null) {
            SOAPConstants sc = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
            selectedElem = WSSecurityUtil.findBodyElement(doc, sc);
            if (selectedElem == null) {
                throw new ResourceResolverException("generic.EmptyMessage", new Object[]{"Body element not found"}, uri, BaseURI);
            }
            String cId = selectedElem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            if (!id.equals(cId)) {
                cId = null;
                selectedElem = WSSecurityUtil.getElementByWsuId(doc, uriNodeValue);
                if (selectedElem != null) {
                    cId = selectedElem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                } else {
                    selectedElem = WSSecurityUtil.getElementByGenId(doc, uriNodeValue);
                    if (selectedElem != null) {
                        cId = selectedElem.getAttribute("Id");
                    }
                }
                if (cId == null) {
                    throw new ResourceResolverException("generic.EmptyMessage", new Object[]{"Id not found"}, uri, BaseURI);
                }
            }
        }
        XMLSignatureInput result = new XMLSignatureInput((Node)selectedElem);
        result.setMIMEType("text/xml");
        try {
            URI uriNew = new URI(new URI(BaseURI), uri.getNodeValue());
            result.setSourceURI(uriNew.toString());
        }
        catch (URI.MalformedURIException ex) {
            result.setSourceURI(BaseURI);
        }
        if (this.doDebug) {
            log.debug((Object)("exit engineResolve, result: " + result));
        }
        return result;
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (uri == null) {
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        return uriNodeValue.startsWith("#");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

