/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Strings;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Preconditions {
    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl, @Nullable Object object) {
        if (!bl) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl, @Nullable String string, int n) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n));
        }
    }

    public static void checkArgument(boolean bl, @Nullable String string, long l) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l));
        }
    }

    public static void checkArgument(boolean bl, @Nullable String string, @Nullable Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object));
        }
    }

    public static void checkArgument(boolean bl, @Nullable String string, @Nullable Object object, int n) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, n));
        }
    }

    public static void checkArgument(boolean bl, @Nullable String string, @Nullable Object object, @Nullable Object object2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, object2));
        }
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl, @Nullable Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl, @Nullable String string, @Nullable Object object) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, object));
        }
    }

    @CanIgnoreReturnValue
    public static Object checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    @CanIgnoreReturnValue
    public static Object checkNotNull(Object object, @Nullable Object object2) {
        if (object == null) {
            throw new NullPointerException(String.valueOf(object2));
        }
        return object;
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int n, int n2) {
        return Preconditions.checkElementIndex(n, n2, "index");
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int n, int n2, @Nullable String string) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(n, n2, string));
        }
        return n;
    }

    private static String badElementIndex(int n, int n2, @Nullable String string) {
        if (n < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string, n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("negative size: " + n2);
        }
        return Strings.lenientFormat("%s (%s) must be less than size (%s)", string, n, n2);
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int n, int n2) {
        return Preconditions.checkPositionIndex(n, n2, "index");
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int n, int n2, @Nullable String string) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(n, n2, string));
        }
        return n;
    }

    private static String badPositionIndex(int n, int n2, @Nullable String string) {
        if (n < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string, n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("negative size: " + n2);
        }
        return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", string, n, n2);
    }

    public static void checkPositionIndexes(int n, int n2, int n3) {
        if (n < 0 || n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n, n2, n3));
        }
    }

    private static String badPositionIndexes(int n, int n2, int n3) {
        if (n < 0 || n > n3) {
            return Preconditions.badPositionIndex(n, n3, "start index");
        }
        if (n2 < 0 || n2 > n3) {
            return Preconditions.badPositionIndex(n2, n3, "end index");
        }
        return Strings.lenientFormat("end index (%s) must not be less than start index (%s)", n2, n);
    }
}

