/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.purgatory;

import com.yammer.metrics.core.Meter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchPartitionStatus;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogReadResult;
import org.apache.kafka.storage.internals.log.RemoteLogReadResult;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedRemoteFetch
extends DelayedOperation {
    private static final Logger LOG = LoggerFactory.getLogger(DelayedRemoteFetch.class);
    private static final KafkaMetricsGroup METRICS_GROUP = new KafkaMetricsGroup("kafka.server", "DelayedRemoteFetchMetrics");
    private static final Meter EXPIRED_REQUEST_METER = METRICS_GROUP.newMeter("ExpiresPerSec", "requests", TimeUnit.SECONDS);
    private final Map<TopicIdPartition, Future<Void>> remoteFetchTasks;
    private final Map<TopicIdPartition, CompletableFuture<RemoteLogReadResult>> remoteFetchResults;
    private final Map<TopicIdPartition, RemoteStorageFetchInfo> remoteFetchInfos;
    private final Map<TopicIdPartition, FetchPartitionStatus> fetchPartitionStatus;
    private final FetchParams fetchParams;
    private final Map<TopicIdPartition, LogReadResult> localReadResults;
    private final Consumer<TopicPartition> partitionOrException;
    private final Consumer<Map<TopicIdPartition, FetchPartitionData>> responseCallback;

    public DelayedRemoteFetch(Map<TopicIdPartition, Future<Void>> remoteFetchTasks, Map<TopicIdPartition, CompletableFuture<RemoteLogReadResult>> remoteFetchResults, Map<TopicIdPartition, RemoteStorageFetchInfo> remoteFetchInfos, long remoteFetchMaxWaitMs, Map<TopicIdPartition, FetchPartitionStatus> fetchPartitionStatus, FetchParams fetchParams, Map<TopicIdPartition, LogReadResult> localReadResults, Consumer<TopicPartition> partitionOrException, Consumer<Map<TopicIdPartition, FetchPartitionData>> responseCallback) {
        super(remoteFetchMaxWaitMs);
        this.remoteFetchTasks = remoteFetchTasks;
        this.remoteFetchResults = remoteFetchResults;
        this.remoteFetchInfos = remoteFetchInfos;
        this.fetchPartitionStatus = fetchPartitionStatus;
        this.fetchParams = fetchParams;
        this.localReadResults = localReadResults;
        this.partitionOrException = partitionOrException;
        this.responseCallback = responseCallback;
        if (fetchParams.isFromFollower()) {
            throw new IllegalStateException("The follower should not invoke remote fetch. Fetch params are: " + String.valueOf(fetchParams));
        }
    }

    public boolean tryComplete() {
        for (Map.Entry<TopicIdPartition, FetchPartitionStatus> entry : this.fetchPartitionStatus.entrySet()) {
            TopicIdPartition topicPartition = entry.getKey();
            FetchPartitionStatus fetchStatus = entry.getValue();
            LogOffsetMetadata fetchOffset = fetchStatus.startOffsetMetadata();
            try {
                if (fetchOffset.equals(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA)) continue;
                this.partitionOrException.accept(topicPartition.topicPartition());
            }
            catch (KafkaStorageException e) {
                LOG.debug("Partition {} is in an offline log directory, satisfy {} immediately.", (Object)topicPartition, (Object)this.fetchParams);
                return this.forceComplete();
            }
            catch (UnknownTopicOrPartitionException e) {
                LOG.debug("Broker no longer knows of partition {}, satisfy {} immediately", (Object)topicPartition, (Object)this.fetchParams);
                return this.forceComplete();
            }
            catch (NotLeaderOrFollowerException e) {
                LOG.debug("Broker is no longer the leader or follower of {}, satisfy {} immediately", (Object)topicPartition, (Object)this.fetchParams);
                return this.forceComplete();
            }
        }
        if (this.remoteFetchResults.values().stream().allMatch(CompletableFuture::isDone)) {
            return this.forceComplete();
        }
        return false;
    }

    public void onExpiration() {
        this.remoteFetchTasks.forEach((topicIdPartition, task) -> {
            if (task != null && !task.isDone() && !task.cancel(false)) {
                LOG.debug("Remote fetch task for remoteFetchInfo: {} could not be cancelled.", (Object)this.remoteFetchInfos.get(topicIdPartition));
            }
        });
        EXPIRED_REQUEST_METER.mark();
    }

    public void onComplete() {
        LinkedHashMap fetchPartitionData = new LinkedHashMap();
        this.localReadResults.forEach((tpId, result) -> {
            CompletableFuture<RemoteLogReadResult> remoteFetchResult = this.remoteFetchResults.get(tpId);
            if (this.remoteFetchResults.containsKey(tpId) && remoteFetchResult.isDone() && result.error() == Errors.NONE && result.info().delayedRemoteStorageFetch.isPresent()) {
                if (remoteFetchResult.join().error().isPresent()) {
                    fetchPartitionData.put(tpId, new LogReadResult(Errors.forException((Throwable)remoteFetchResult.join().error().get())).toFetchPartitionData(false));
                } else {
                    FetchDataInfo info = remoteFetchResult.join().fetchDataInfo().get();
                    fetchPartitionData.put(tpId, new FetchPartitionData(result.error(), result.highWatermark(), result.leaderLogStartOffset(), info.records, Optional.empty(), result.lastStableOffset(), info.abortedTransactions, result.preferredReadReplica(), false));
                }
            } else {
                fetchPartitionData.put(tpId, result.toFetchPartitionData(false));
            }
        });
        this.responseCallback.accept(fetchPartitionData);
    }

    public static long expiredRequestCount() {
        return EXPIRED_REQUEST_METER.count();
    }
}

