/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.internals.AbstractMembershipManager;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.metrics.ShareRebalanceMetricsManager;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareGroupHeartbeatResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;

public class ShareMembershipManager
extends AbstractMembershipManager<ShareGroupHeartbeatResponse> {
    protected final String rackId;

    public ShareMembershipManager(LogContext logContext, String groupId, String rackId, SubscriptionState subscriptions, Metadata metadata, Time time, Metrics metrics) {
        this(logContext, groupId, rackId, subscriptions, metadata, time, new ShareRebalanceMetricsManager(metrics));
    }

    ShareMembershipManager(LogContext logContext, String groupId, String rackId, SubscriptionState subscriptions, Metadata metadata, Time time, ShareRebalanceMetricsManager metricsManager) {
        super(groupId, subscriptions, metadata, logContext.logger(ShareMembershipManager.class), time, metricsManager, false);
        this.rackId = rackId;
    }

    public String rackId() {
        return this.rackId;
    }

    @Override
    public void onHeartbeatSuccess(ShareGroupHeartbeatResponse response) {
        ShareGroupHeartbeatResponseData responseData = response.data();
        if (responseData.errorCode() != Errors.NONE.code()) {
            String errorMessage = String.format("Unexpected error in Heartbeat response. Expected no error, but received: %s", new Object[]{Errors.forCode(responseData.errorCode())});
            throw new IllegalArgumentException(errorMessage);
        }
        MemberState state = this.state();
        if (state == MemberState.LEAVING) {
            this.log.debug("Ignoring heartbeat response received from broker. Member {} with epoch {} is already leaving the group.", (Object)this.memberId, (Object)this.memberEpoch);
            return;
        }
        if (state == MemberState.UNSUBSCRIBED && responseData.memberEpoch() < 0 && this.maybeCompleteLeaveInProgress()) {
            this.log.debug("Member {} with epoch {} received a successful response to the heartbeat to leave the group and completed the leave operation. ", (Object)this.memberId, (Object)this.memberEpoch);
            return;
        }
        if (this.isNotInGroup()) {
            this.log.debug("Ignoring heartbeat response received from broker. Member {} is in {} state so it's not a member of the group. ", (Object)this.memberId, (Object)state);
            return;
        }
        if (responseData.memberEpoch() < 0) {
            this.log.debug("Ignoring heartbeat response received from broker. Member {} with epoch {} is in {} state and the member epoch is invalid: {}. ", new Object[]{this.memberId, this.memberEpoch, state, responseData.memberEpoch()});
            this.maybeCompleteLeaveInProgress();
            return;
        }
        this.updateMemberEpoch(responseData.memberEpoch());
        ShareGroupHeartbeatResponseData.Assignment assignment = responseData.assignment();
        if (assignment != null) {
            if (!state.canHandleNewAssignment()) {
                this.log.debug("Ignoring new assignment {} received from server because member is in {} state.", (Object)assignment, (Object)state);
                return;
            }
            HashMap<Uuid, SortedSet<Integer>> newAssignment = new HashMap<Uuid, SortedSet<Integer>>();
            assignment.topicPartitions().forEach(topicPartition -> newAssignment.put(topicPartition.topicId(), new TreeSet<Integer>(topicPartition.partitions())));
            this.processAssignmentReceived(newAssignment);
        }
    }

    @Override
    public int joinGroupEpoch() {
        return 0;
    }

    @Override
    public int leaveGroupEpoch() {
        return -1;
    }
}

