/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.nio.ByteBuffer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public record OffsetSync(TopicPartition topicPartition, long upstreamOffset, long downstreamOffset) {
    public static final String TOPIC_KEY = "topic";
    public static final String PARTITION_KEY = "partition";
    public static final String UPSTREAM_OFFSET_KEY = "upstreamOffset";
    public static final String DOWNSTREAM_OFFSET_KEY = "offset";
    public static final Schema VALUE_SCHEMA = new Schema(new Field[]{new Field("upstreamOffset", (Type)Type.INT64), new Field("offset", (Type)Type.INT64)});
    public static final Schema KEY_SCHEMA = new Schema(new Field[]{new Field("topic", (Type)Type.STRING), new Field("partition", (Type)Type.INT32)});

    @Override
    public String toString() {
        return String.format("OffsetSync{topicPartition=%s, upstreamOffset=%d, downstreamOffset=%d}", this.topicPartition, this.upstreamOffset, this.downstreamOffset);
    }

    ByteBuffer serializeValue() {
        Struct struct = this.valueStruct();
        ByteBuffer buffer = ByteBuffer.allocate(VALUE_SCHEMA.sizeOf((Object)struct));
        VALUE_SCHEMA.write(buffer, (Object)struct);
        buffer.flip();
        return buffer;
    }

    ByteBuffer serializeKey() {
        Struct struct = this.keyStruct();
        ByteBuffer buffer = ByteBuffer.allocate(KEY_SCHEMA.sizeOf((Object)struct));
        KEY_SCHEMA.write(buffer, (Object)struct);
        buffer.flip();
        return buffer;
    }

    public static OffsetSync deserializeRecord(ConsumerRecord<byte[], byte[]> record) {
        Struct keyStruct = KEY_SCHEMA.read(ByteBuffer.wrap((byte[])record.key()));
        String topic = keyStruct.getString(TOPIC_KEY);
        int partition = keyStruct.getInt(PARTITION_KEY);
        Struct valueStruct = VALUE_SCHEMA.read(ByteBuffer.wrap((byte[])record.value()));
        long upstreamOffset = valueStruct.getLong(UPSTREAM_OFFSET_KEY);
        long downstreamOffset = valueStruct.getLong(DOWNSTREAM_OFFSET_KEY);
        return new OffsetSync(new TopicPartition(topic, partition), upstreamOffset, downstreamOffset);
    }

    private Struct valueStruct() {
        Struct struct = new Struct(VALUE_SCHEMA);
        struct.set(UPSTREAM_OFFSET_KEY, (Object)this.upstreamOffset);
        struct.set(DOWNSTREAM_OFFSET_KEY, (Object)this.downstreamOffset);
        return struct;
    }

    private Struct keyStruct() {
        Struct struct = new Struct(KEY_SCHEMA);
        struct.set(TOPIC_KEY, (Object)this.topicPartition.topic());
        struct.set(PARTITION_KEY, (Object)this.topicPartition.partition());
        return struct;
    }

    byte[] recordKey() {
        return this.serializeKey().array();
    }

    byte[] recordValue() {
        return this.serializeValue().array();
    }
}

