/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface DecodeJson<T> {
    public T decode(JsonNode var1) throws JsonMappingException;

    public static JsonMappingException throwJsonMappingException(String expectedType, JsonNode node) {
        return new JsonMappingException(null, String.format("Expected `%s` value, received %s", expectedType, node));
    }

    public static <E> DecodeJson<Optional<E>> decodeOptional(DecodeJson<E> decodeJson) {
        return node -> {
            if (node.isNull()) {
                return Optional.empty();
            }
            return Optional.of(decodeJson.decode(node));
        };
    }

    public static <E> DecodeJson<List<E>> decodeList(DecodeJson<E> decodeJson) {
        return node -> {
            if (node.isArray()) {
                ArrayList result = new ArrayList();
                Iterator elements = node.elements();
                while (elements.hasNext()) {
                    result.add(decodeJson.decode((JsonNode)elements.next()));
                }
                return result;
            }
            throw DecodeJson.throwJsonMappingException("JSON array", node);
        };
    }

    public static <V> DecodeJson<Map<String, V>> decodeMap(DecodeJson<V> decodeJson) {
        return node -> {
            if (node.isObject()) {
                HashMap result = new HashMap();
                Iterator elements = node.fields();
                while (elements.hasNext()) {
                    Map.Entry next = (Map.Entry)elements.next();
                    result.put((String)next.getKey(), decodeJson.decode((JsonNode)next.getValue()));
                }
                return result;
            }
            throw DecodeJson.throwJsonMappingException("JSON object", node);
        };
    }

    public static final class DecodeString
    implements DecodeJson<String> {
        @Override
        public String decode(JsonNode node) throws JsonMappingException {
            if (node.isTextual()) {
                return node.textValue();
            }
            throw DecodeJson.throwJsonMappingException(String.class.getSimpleName(), node);
        }
    }

    public static final class DecodeLong
    implements DecodeJson<Long> {
        @Override
        public Long decode(JsonNode node) throws JsonMappingException {
            if (node.isLong() || node.isInt()) {
                return node.longValue();
            }
            throw DecodeJson.throwJsonMappingException(Long.class.getSimpleName(), node);
        }
    }

    public static final class DecodeInteger
    implements DecodeJson<Integer> {
        @Override
        public Integer decode(JsonNode node) throws JsonMappingException {
            if (node.isInt()) {
                return node.intValue();
            }
            throw DecodeJson.throwJsonMappingException(Integer.class.getSimpleName(), node);
        }
    }

    public static final class DecodeDouble
    implements DecodeJson<Double> {
        @Override
        public Double decode(JsonNode node) throws JsonMappingException {
            if (node.isDouble() || node.isLong() || node.isInt()) {
                return node.doubleValue();
            }
            throw DecodeJson.throwJsonMappingException(Double.class.getSimpleName(), node);
        }
    }

    public static final class DecodeBoolean
    implements DecodeJson<Boolean> {
        @Override
        public Boolean decode(JsonNode node) throws JsonMappingException {
            if (node.isBoolean()) {
                return node.booleanValue();
            }
            throw DecodeJson.throwJsonMappingException(Boolean.class.getSimpleName(), node);
        }
    }
}

