/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.util.ConnectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetUtils {
    private static final Logger log = LoggerFactory.getLogger(OffsetUtils.class);

    public static void validateFormat(Object offsetData) {
        if (offsetData == null) {
            return;
        }
        if (!(offsetData instanceof Map)) {
            throw new DataException("Offsets must be specified as a Map");
        }
        OffsetUtils.validateFormat((Map)offsetData);
    }

    public static <K, V> void validateFormat(Map<K, V> offsetData) {
        if (offsetData == null) {
            return;
        }
        for (Map.Entry<K, V> entry : offsetData.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new DataException("Offsets may only use String keys");
            }
            V value = entry.getValue();
            if (value == null) continue;
            Schema.Type schemaType = ConnectSchema.schemaType(value.getClass());
            if (schemaType == null) {
                throw new DataException("Offsets may only contain primitive types as values, but field " + String.valueOf(entry.getKey()) + " contains " + String.valueOf(value.getClass()));
            }
            if (schemaType.isPrimitive()) continue;
            throw new DataException("Offsets may only contain primitive types as values, but field " + String.valueOf(entry.getKey()) + " contains " + String.valueOf(schemaType));
        }
    }

    public static void processPartitionKey(byte[] partitionKey, byte[] offsetValue, Converter keyConverter, Map<String, Set<Map<String, Object>>> connectorPartitions) {
        Object deserializedKey;
        if (partitionKey == null) {
            log.warn("Ignoring offset partition key with an unexpected null value");
            return;
        }
        try {
            deserializedKey = keyConverter.toConnectData("", partitionKey).value();
        }
        catch (DataException e) {
            log.warn("Ignoring offset partition key with unknown serialization. Expected json.", (Throwable)e);
            return;
        }
        if (!(deserializedKey instanceof List)) {
            log.warn("Ignoring offset partition key with an unexpected format. Expected type: {}, actual type: {}", (Object)List.class.getName(), (Object)ConnectUtils.className(deserializedKey));
            return;
        }
        List keyList = (List)deserializedKey;
        if (keyList.size() != 2) {
            log.warn("Ignoring offset partition key with an unexpected number of elements. Expected: 2, actual: {}", (Object)keyList.size());
            return;
        }
        if (!(keyList.get(0) instanceof String)) {
            log.warn("Ignoring offset partition key with an unexpected format for the first element in the partition key list. Expected type: {}, actual type: {}", (Object)String.class.getName(), (Object)ConnectUtils.className(keyList.get(0)));
            return;
        }
        if (!(keyList.get(1) instanceof Map)) {
            if (keyList.get(1) != null) {
                log.warn("Ignoring offset partition key with an unexpected format for the second element in the partition key list. Expected type: {}, actual type: {}", (Object)Map.class.getName(), (Object)ConnectUtils.className(keyList.get(1)));
            }
            return;
        }
        String connectorName = (String)keyList.get(0);
        Map partition = (Map)keyList.get(1);
        connectorPartitions.computeIfAbsent(connectorName, ignored -> new HashSet());
        if (offsetValue == null) {
            connectorPartitions.get(connectorName).remove(partition);
        } else {
            connectorPartitions.get(connectorName).add(partition);
        }
    }
}

