/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.runtime.rest.entities.LoggerLevel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loggers {
    private static final Logger log = LoggerFactory.getLogger(Loggers.class);
    private static final String ROOT_LOGGER_NAME = "root";
    private static final List<String> VALID_ROOT_LOGGER_NAMES = List.of("", "root");
    private final Time time;
    private final Map<String, Long> lastModifiedTimes;

    public Loggers(Time time) {
        this.time = time;
        this.lastModifiedTimes = new HashMap<String, Long>();
    }

    public synchronized LoggerLevel level(String logger) {
        Objects.requireNonNull(logger, "Logger may not be null");
        org.apache.logging.log4j.Logger foundLogger = null;
        if (this.isValidRootLoggerName(logger)) {
            foundLogger = this.rootLogger();
        } else {
            Collection<org.apache.logging.log4j.Logger> currentLoggers = this.currentLoggers().values();
            for (org.apache.logging.log4j.Logger currentLogger : currentLoggers) {
                if (!logger.equals(currentLogger.getName())) continue;
                foundLogger = currentLogger;
                break;
            }
        }
        if (foundLogger == null) {
            log.warn("Unable to find level for logger {}", (Object)logger);
            return null;
        }
        return this.loggerLevel(foundLogger);
    }

    public synchronized Map<String, LoggerLevel> allLevels() {
        return this.currentLoggers().values().stream().filter(logger -> !logger.getLevel().equals((Object)Level.OFF)).collect(Collectors.toMap(this::getLoggerName, this::loggerLevel, (existing, replacing) -> replacing, TreeMap::new));
    }

    public synchronized List<String> setLevel(String namespace, Level level) {
        Objects.requireNonNull(namespace, "Logging namespace may not be null");
        Objects.requireNonNull(level, "Level may not be null");
        String internalNameSpace = this.isValidRootLoggerName(namespace) ? "" : namespace;
        log.info("Setting level of namespace {} and children to {}", (Object)internalNameSpace, (Object)level);
        Collection<org.apache.logging.log4j.Logger> loggers = this.loggers(internalNameSpace);
        Map<String, LoggerLevel> nameToLevel = this.allLevels();
        ArrayList<String> result = new ArrayList<String>();
        Configurator.setAllLevels((String)internalNameSpace, (Level)level);
        for (org.apache.logging.log4j.Logger logger : loggers) {
            String oldLevel;
            String name = this.getLoggerName(logger);
            String newLevel = logger.getLevel().name();
            if (newLevel.equalsIgnoreCase(oldLevel = nameToLevel.getOrDefault(name, new LoggerLevel("", this.time.milliseconds())).level())) continue;
            this.lastModifiedTimes.put(name, this.time.milliseconds());
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    private synchronized Collection<org.apache.logging.log4j.Logger> loggers(String namespace) {
        Objects.requireNonNull(namespace, "Logging namespace may not be null");
        if (this.isValidRootLoggerName(namespace)) {
            return this.currentLoggers().values();
        }
        ArrayList<org.apache.logging.log4j.Logger> result = new ArrayList<org.apache.logging.log4j.Logger>();
        Map<String, org.apache.logging.log4j.Logger> nameToLogger = this.currentLoggers();
        org.apache.logging.log4j.Logger ancestorLogger = this.lookupLogger(namespace);
        Collection<org.apache.logging.log4j.Logger> currentLoggers = nameToLogger.values();
        boolean present = false;
        for (org.apache.logging.log4j.Logger currentLogger : currentLoggers) {
            if (currentLogger.getName().startsWith(namespace)) {
                result.add(currentLogger);
            }
            if (!namespace.equals(currentLogger.getName())) continue;
            present = true;
        }
        if (!present) {
            result.add(ancestorLogger);
        }
        return result;
    }

    org.apache.logging.log4j.Logger lookupLogger(String logger) {
        return LogManager.getLogger((String)(this.isValidRootLoggerName(logger) ? "" : logger));
    }

    Map<String, org.apache.logging.log4j.Logger> currentLoggers() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        HashMap<String, org.apache.logging.log4j.Logger> results = new HashMap<String, org.apache.logging.log4j.Logger>();
        context.getConfiguration().getLoggers().forEach((name, logger) -> results.put((String)name, LogManager.getLogger((String)name)));
        context.getLoggerRegistry().getLoggers().forEach(logger -> results.put(logger.getName(), (org.apache.logging.log4j.Logger)logger));
        return results;
    }

    org.apache.logging.log4j.Logger rootLogger() {
        return LogManager.getRootLogger();
    }

    private LoggerLevel loggerLevel(org.apache.logging.log4j.Logger logger) {
        Long lastModified = this.lastModifiedTimes.get(this.getLoggerName(logger));
        return new LoggerLevel(Objects.toString(logger.getLevel()), lastModified);
    }

    private boolean isValidRootLoggerName(String namespace) {
        return VALID_ROOT_LOGGER_NAMES.stream().anyMatch(rootLoggerNames -> rootLoggerNames.equalsIgnoreCase(namespace));
    }

    private String getLoggerName(org.apache.logging.log4j.Logger logger) {
        return logger.getName().equals("") ? ROOT_LOGGER_NAME : logger.getName();
    }
}

