/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotValue;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValue;
import org.apache.kafka.server.share.persister.PersisterStateBatch;

public class ShareGroupOffset {
    private final int snapshotEpoch;
    private final int stateEpoch;
    private final int leaderEpoch;
    private final long startOffset;
    private final List<PersisterStateBatch> stateBatches;

    private ShareGroupOffset(int snapshotEpoch, int stateEpoch, int leaderEpoch, long startOffset, List<PersisterStateBatch> stateBatches) {
        this.snapshotEpoch = snapshotEpoch;
        this.stateEpoch = stateEpoch;
        this.leaderEpoch = leaderEpoch;
        this.startOffset = startOffset;
        this.stateBatches = stateBatches;
    }

    public int snapshotEpoch() {
        return this.snapshotEpoch;
    }

    public int stateEpoch() {
        return this.stateEpoch;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public List<PersisterStateBatch> stateBatches() {
        return Collections.unmodifiableList(this.stateBatches);
    }

    private static PersisterStateBatch toPersisterOffsetsStateBatch(ShareSnapshotValue.StateBatch stateBatch) {
        return new PersisterStateBatch(stateBatch.firstOffset(), stateBatch.lastOffset(), stateBatch.deliveryState(), stateBatch.deliveryCount());
    }

    private static PersisterStateBatch toPersisterOffsetsStateBatch(ShareUpdateValue.StateBatch stateBatch) {
        return new PersisterStateBatch(stateBatch.firstOffset(), stateBatch.lastOffset(), stateBatch.deliveryState(), stateBatch.deliveryCount());
    }

    public static ShareGroupOffset fromRecord(ShareSnapshotValue record) {
        return new ShareGroupOffset(record.snapshotEpoch(), record.stateEpoch(), record.leaderEpoch(), record.startOffset(), record.stateBatches().stream().map(ShareGroupOffset::toPersisterOffsetsStateBatch).collect(Collectors.toList()));
    }

    public static ShareGroupOffset fromRecord(ShareUpdateValue record) {
        return new ShareGroupOffset(record.snapshotEpoch(), -1, record.leaderEpoch(), record.startOffset(), record.stateBatches().stream().map(ShareGroupOffset::toPersisterOffsetsStateBatch).collect(Collectors.toList()));
    }

    public static ShareGroupOffset fromRequest(WriteShareGroupStateRequestData.PartitionData data) {
        return ShareGroupOffset.fromRequest(data, 0);
    }

    public static ShareGroupOffset fromRequest(WriteShareGroupStateRequestData.PartitionData data, int snapshotEpoch) {
        return new ShareGroupOffset(snapshotEpoch, data.stateEpoch(), data.leaderEpoch(), data.startOffset(), data.stateBatches().stream().map(PersisterStateBatch::from).collect(Collectors.toList()));
    }

    public LinkedHashSet<PersisterStateBatch> stateBatchAsSet() {
        return new LinkedHashSet<PersisterStateBatch>(this.stateBatches);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShareGroupOffset that = (ShareGroupOffset)o;
        return this.snapshotEpoch == that.snapshotEpoch && this.stateEpoch == that.stateEpoch && this.leaderEpoch == that.leaderEpoch && this.startOffset == that.startOffset && Objects.equals(this.stateBatches, that.stateBatches);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotEpoch, this.stateEpoch, this.leaderEpoch, this.startOffset, this.stateBatches);
    }

    public String toString() {
        return "ShareGroupOffset{snapshotEpoch=" + this.snapshotEpoch + ", stateEpoch=" + this.stateEpoch + ", leaderEpoch=" + this.leaderEpoch + ", startOffset=" + this.startOffset + ", stateBatches=" + String.valueOf(this.stateBatches) + "}";
    }

    public static class Builder {
        private int snapshotEpoch;
        private int stateEpoch;
        private int leaderEpoch;
        private long startOffset;
        private List<PersisterStateBatch> stateBatches;

        public Builder setSnapshotEpoch(int snapshotEpoch) {
            this.snapshotEpoch = snapshotEpoch;
            return this;
        }

        public Builder setStateEpoch(int stateEpoch) {
            this.stateEpoch = stateEpoch;
            return this;
        }

        public Builder setLeaderEpoch(int leaderEpoch) {
            this.leaderEpoch = leaderEpoch;
            return this;
        }

        public Builder setStartOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        public Builder setStateBatches(List<PersisterStateBatch> stateBatches) {
            this.stateBatches = stateBatches;
            return this;
        }

        public ShareGroupOffset build() {
            return new ShareGroupOffset(this.snapshotEpoch, this.stateEpoch, this.leaderEpoch, this.startOffset, this.stateBatches);
        }
    }
}

