/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import java.util.OptionalLong;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupTopicPartition;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.UnknownKey;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class GroupMetadataManager$ {
    public static final GroupMetadataManager$ MODULE$ = new GroupMetadataManager$();
    private static final String MetricsGroup = "group-coordinator-metrics";
    private static final String LoadTimeSensor = "GroupPartitionLoadTime";
    private static final String OffsetCommitsSensor = "OffsetCommits";
    private static final String OffsetExpiredSensor = "OffsetExpired";

    public String MetricsGroup() {
        return MetricsGroup;
    }

    public String LoadTimeSensor() {
        return LoadTimeSensor;
    }

    public String OffsetCommitsSensor() {
        return OffsetCommitsSensor;
    }

    public String OffsetExpiredSensor() {
        return OffsetExpiredSensor;
    }

    public byte[] offsetCommitKey(String groupId, TopicPartition topicPartition) {
        return MessageUtil.toVersionPrefixedBytes((short)1, (Message)new OffsetCommitKey().setGroup(groupId).setTopic(topicPartition.topic()).setPartition(topicPartition.partition()));
    }

    public byte[] groupMetadataKey(String groupId) {
        return MessageUtil.toVersionPrefixedBytes((short)2, (Message)new org.apache.kafka.coordinator.group.generated.GroupMetadataKey().setGroup(groupId));
    }

    public byte[] offsetCommitValue(OffsetAndMetadata offsetAndMetadata, short maxVersion) {
        return MessageUtil.toVersionPrefixedBytes((short)(offsetAndMetadata.expireTimestampMs.isPresent() ? (short)Math.min(1, maxVersion) : maxVersion), (Message)new OffsetCommitValue().setOffset(offsetAndMetadata.committedOffset).setMetadata(offsetAndMetadata.metadata).setCommitTimestamp(offsetAndMetadata.commitTimestampMs).setLeaderEpoch(offsetAndMetadata.leaderEpoch.orElse(-1)).setExpireTimestamp(offsetAndMetadata.expireTimestampMs.orElse(-1L)));
    }

    public short offsetCommitValue$default$2() {
        return 3;
    }

    public byte[] groupMetadataValue(GroupMetadata groupMetadata, Map<String, byte[]> assignment, short version) {
        return MessageUtil.toVersionPrefixedBytes((short)version, (Message)new GroupMetadataValue().setProtocolType((String)groupMetadata.protocolType().getOrElse((Function0 & Serializable)() -> "")).setGeneration(groupMetadata.generationId()).setProtocol((String)groupMetadata.protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setLeader(groupMetadata.leaderOrNull()).setCurrentStateTimestamp(groupMetadata.currentStateTimestampOrDefault()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)groupMetadata.allMemberMetadata().map((Function1 & Serializable)memberMetadata -> new GroupMetadataValue.MemberMetadata().setMemberId(memberMetadata.memberId()).setClientId(memberMetadata.clientId()).setClientHost(memberMetadata.clientHost()).setSessionTimeout(memberMetadata.sessionTimeoutMs()).setRebalanceTimeout(memberMetadata.rebalanceTimeoutMs()).setGroupInstanceId((String)memberMetadata.groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setSubscription((byte[])groupMetadata.protocolName().map((Function1 & Serializable)protocol -> memberMetadata.metadata((String)protocol)).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol.");
        })).setAssignment((byte[])assignment.getOrElse((Object)memberMetadata.memberId(), (Function0 & Serializable)() -> {
            throw new IllegalStateException("Attempted to write member " + memberMetadata.memberId() + " of group " + groupMetadata.groupId() + " with no assignment.");
        })))).asJava()));
    }

    public short groupMetadataValue$default$3() {
        return 3;
    }

    public BaseKey readMessageKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        if (version >= 0 && version <= 1) {
            OffsetCommitKey key = new OffsetCommitKey((Readable)new ByteBufferAccessor(buffer), version);
            return new OffsetKey(version, new GroupTopicPartition(key.group(), new TopicPartition(key.topic(), key.partition())));
        }
        if (version >= 2 && version <= 2) {
            org.apache.kafka.coordinator.group.generated.GroupMetadataKey key = new org.apache.kafka.coordinator.group.generated.GroupMetadataKey((Readable)new ByteBufferAccessor(buffer), version);
            return new GroupMetadataKey(version, key.group());
        }
        return new UnknownKey(version);
    }

    public OffsetAndMetadata readOffsetMessageValue(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        short version = buffer.getShort();
        if (version >= 0 && version <= 4) {
            OffsetCommitValue value = new OffsetCommitValue((Readable)new ByteBufferAccessor(buffer), version);
            return new OffsetAndMetadata(value.offset(), value.leaderEpoch() == -1 ? OptionalInt.empty() : OptionalInt.of(value.leaderEpoch()), value.metadata(), value.commitTimestamp(), value.expireTimestamp() == -1L ? OptionalLong.empty() : OptionalLong.of(value.expireTimestamp()));
        }
        throw new IllegalStateException("Unknown offset message version: " + version);
    }

    public GroupMetadata readGroupMessageValue(String groupId, ByteBuffer buffer, Time time) {
        if (buffer == null) {
            return null;
        }
        short version = buffer.getShort();
        if (version >= 0 && version <= 4) {
            GroupMetadataValue value = new GroupMetadataValue((Readable)new ByteBufferAccessor(buffer), version);
            Buffer members = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(value.members()).asScala().map((Function1 & Serializable)memberMetadata -> new MemberMetadata(memberMetadata.memberId(), (Option<String>)Option$.MODULE$.apply((Object)memberMetadata.groupInstanceId()), memberMetadata.clientId(), memberMetadata.clientHost(), version == 0 ? memberMetadata.sessionTimeout() : memberMetadata.rebalanceTimeout(), memberMetadata.sessionTimeout(), value.protocolType(), (List<Tuple2<String, byte[]>>)new .colon.colon((Object)new Tuple2((Object)value.protocol(), (Object)memberMetadata.subscription()), (List)Nil$.MODULE$), memberMetadata.assignment()));
            return GroupMetadata$.MODULE$.loadGroup(groupId, (GroupState)(members.isEmpty() ? Empty$.MODULE$ : Stable$.MODULE$), value.generation(), value.protocolType(), value.protocol(), value.leader(), (Option<Object>)(value.currentStateTimestamp() == -1L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)value.currentStateTimestamp()))), (Iterable<MemberMetadata>)members, time);
        }
        throw new IllegalStateException("Unknown group metadata message version: " + version);
    }

    public Errors maybeConvertOffsetCommitError(Errors error) {
        if (Errors.NETWORK_EXCEPTION.equals(error)) {
            return Errors.COORDINATOR_LOAD_IN_PROGRESS;
        }
        if (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(error) ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(error) ? true : Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(error))) {
            return Errors.COORDINATOR_NOT_AVAILABLE;
        }
        if (Errors.NOT_LEADER_OR_FOLLOWER.equals(error) ? true : Errors.KAFKA_STORAGE_ERROR.equals(error)) {
            return Errors.NOT_COORDINATOR;
        }
        if (Errors.MESSAGE_TOO_LARGE.equals(error) ? true : (Errors.RECORD_LIST_TOO_LARGE.equals(error) ? true : Errors.INVALID_FETCH_SIZE.equals(error))) {
            return Errors.INVALID_COMMIT_OFFSET_SIZE;
        }
        return error;
    }

    private GroupMetadataManager$() {
    }
}

