/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinatorAdapter$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.SyncGroupResult;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.util.FutureUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r}x!B\u0015+\u0011\u0003\td!B\u001a+\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004\"B\u001f\u0002\t\u0003qd!B\u001a+\u0001)\u0002\u0005\u0002C\u0017\u0005\u0005\u000b\u0007I\u0011\u0002+\t\u0011]#!\u0011!Q\u0001\nUC\u0001\u0002\u0017\u0003\u0003\u0006\u0004%I!\u0017\u0005\tE\u0012\u0011\t\u0011)A\u00055\")1\b\u0002C\u0001G\")a\r\u0002C!O\")1\u000e\u0002C!Y\"9\u0011\u0011\u0003\u0003\u0005B\u0005M\u0001bBA\u0014\t\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003\u000f\"A\u0011IA%\u0011\u001d\ty\u0006\u0002C!\u0003CBq!!\u001e\u0005\t\u0003\n9\bC\u0004\u0002\f\u0012!\t%!$\t\u000f\u0005\u0005F\u0001\"\u0011\u0002$\"9\u00111\u001c\u0003\u0005B\u0005u\u0007bBA{\t\u0011\u0005\u0013q\u001f\u0005\b\u0005?!A\u0011\tB\u0011\u0011\u001d\u0011I\u0003\u0002C\u0005\u0005WAqAa\u0016\u0005\t\u0003\u0012I\u0006C\u0004\u0003p\u0011!\tE!\u001d\t\u000f\t\u001dE\u0001\"\u0003\u0003\n\"9!1\u0017\u0003\u0005B\tU\u0006b\u0002Bf\t\u0011\u0005#Q\u001a\u0005\b\u0007\u000b!A\u0011IB\u0004\u0011\u001d\u0019Y\u0001\u0002C!\u0007\u001bAqa!\b\u0005\t\u0003\u001ay\u0002C\u0004\u00040\u0011!\te!\r\t\u000f\rmB\u0001\"\u0011\u0004>!91\u0011\n\u0003\u0005B\r-\u0003bBB4\t\u0011\u00053\u0011\u000e\u0005\b\u0007c\"A\u0011IB:\u0011\u001d\u0019\u0019\t\u0002C!\u0007\u000bCqa!$\u0005\t\u0003\u001ay\tC\u0004\u0004\"\u0012!\tea)\t\u000f\r\u0015F\u0001\"\u0011\u0004(\"91Q\u0018\u0003\u0005B\r}\u0016aF$s_V\u00048i\\8sI&t\u0017\r^8s\u0003\u0012\f\u0007\u000f^3s\u0015\tYC&A\u0003he>,\bO\u0003\u0002.]\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005y\u0013!B6bM.\f7\u0001\u0001\t\u0003e\u0005i\u0011A\u000b\u0002\u0018\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\fE-\u00199uKJ\u001c\"!A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011'A\u0003baBd\u0017\u0010F\u0005@\u0007+\u001c)oa<\u0004rB\u0011!\u0007B\n\u0004\t\u0005K\u0005C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\u000bAA[1wC&\u0011\u0001j\u0011\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005)\u0013V\"A&\u000b\u0005-b%BA\u0017N\u0015\tycJ\u0003\u0002P!\u00061\u0011\r]1dQ\u0016T\u0011!U\u0001\u0004_J<\u0017BA*L\u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'/F\u0001V!\t\u0011d+\u0003\u0002TU\u0005a1m\\8sI&t\u0017\r^8sA\u0005!A/[7f+\u0005Q\u0006CA.a\u001b\u0005a&BA/_\u0003\u0015)H/\u001b7t\u0015\tyV*\u0001\u0004d_6lwN\\\u0005\u0003Cr\u0013A\u0001V5nK\u0006)A/[7fAQ\u0019q\bZ3\t\u000b5J\u0001\u0019A+\t\u000baK\u0001\u0019\u0001.\u0002+%\u001ch*Z<He>,\boQ8pe\u0012Lg.\u0019;peR\t\u0001\u000e\u0005\u00027S&\u0011!n\u000e\u0002\b\u0005>|G.Z1o\u0003Y\u0019wN\\:v[\u0016\u0014xI]8va\"+\u0017M\u001d;cK\u0006$H\u0003B7|\u0003\u000f\u00012A\\:v\u001b\u0005y'B\u00019r\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003e\u0016\u000bA!\u001e;jY&\u0011Ao\u001c\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007C\u0001<z\u001b\u00059(B\u0001=_\u0003\u001diWm]:bO\u0016L!A_<\u0003E\r{gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u0015a8\u00021\u0001~\u0003\u001d\u0019wN\u001c;fqR\u00042A`A\u0002\u001b\u0005y(bAA\u0001=\u0006A!/Z9vKN$8/C\u0002\u0002\u0006}\u0014aBU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0004\u0002\n-\u0001\r!a\u0003\u0002\u000fI,\u0017/^3tiB\u0019a/!\u0004\n\u0007\u0005=qOA\u0011D_:\u001cX/\\3s\u000fJ|W\u000f\u001d%fCJ$(-Z1u%\u0016\fX/Z:u\t\u0006$\u0018-A\ntQ\u0006\u0014Xm\u0012:pkBDU-\u0019:uE\u0016\fG\u000f\u0006\u0004\u0002\u0016\u0005u\u0011q\u0004\t\u0005]N\f9\u0002E\u0002w\u00033I1!a\u0007x\u0005}\u0019\u0006.\u0019:f\u000fJ|W\u000f\u001d%fCJ$(-Z1u%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006y2\u0001\r! \u0005\b\u0003\u0013a\u0001\u0019AA\u0011!\r1\u00181E\u0005\u0004\u0003K9(AH*iCJ,wI]8va\"+\u0017M\u001d;cK\u0006$(+Z9vKN$H)\u0019;b\u0003%Qw.\u001b8He>,\b\u000f\u0006\u0005\u0002,\u0005M\u0012QGA\u001f!\u0011q7/!\f\u0011\u0007Y\fy#C\u0002\u00022]\u0014QCS8j]\u001e\u0013x.\u001e9SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0003}\u001b\u0001\u0007Q\u0010C\u0004\u0002\n5\u0001\r!a\u000e\u0011\u0007Y\fI$C\u0002\u0002<]\u0014ACS8j]\u001e\u0013x.\u001e9SKF,Xm\u001d;ECR\f\u0007bBA \u001b\u0001\u0007\u0011\u0011I\u0001\u000fEV4g-\u001a:TkB\u0004H.[3s!\rY\u00161I\u0005\u0004\u0003\u000bb&A\u0004\"vM\u001a,'oU;qa2LWM]\u0001\ngft7m\u0012:pkB$\u0002\"a\u0013\u0002T\u0005U\u0013Q\f\t\u0005]N\fi\u0005E\u0002w\u0003\u001fJ1!!\u0015x\u0005U\u0019\u0016P\\2He>,\bOU3ta>t7/\u001a#bi\u0006DQ\u0001 \bA\u0002uDq!!\u0003\u000f\u0001\u0004\t9\u0006E\u0002w\u00033J1!a\u0017x\u0005Q\u0019\u0016P\\2He>,\bOU3rk\u0016\u001cH\u000fR1uC\"9\u0011q\b\bA\u0002\u0005\u0005\u0013!\u00035fCJ$(-Z1u)\u0019\t\u0019'a\u001b\u0002nA!an]A3!\r1\u0018qM\u0005\u0004\u0003S:(!\u0006%fCJ$(-Z1u%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006y>\u0001\r! \u0005\b\u0003\u0013y\u0001\u0019AA8!\r1\u0018\u0011O\u0005\u0004\u0003g:(\u0001\u0006%fCJ$(-Z1u%\u0016\fX/Z:u\t\u0006$\u0018-\u0001\u0006mK\u00064Xm\u0012:pkB$b!!\u001f\u0002\u0002\u0006\r\u0005\u0003\u00028t\u0003w\u00022A^A?\u0013\r\tyh\u001e\u0002\u0017\u0019\u0016\fg/Z$s_V\u0004(+Z:q_:\u001cX\rR1uC\")A\u0010\u0005a\u0001{\"9\u0011\u0011\u0002\tA\u0002\u0005\u0015\u0005c\u0001<\u0002\b&\u0019\u0011\u0011R<\u0003+1+\u0017M^3He>,\bOU3rk\u0016\u001cH\u000fR1uC\u0006QA.[:u\u000fJ|W\u000f]:\u0015\r\u0005=\u0015qSAM!\u0011q7/!%\u0011\u0007Y\f\u0019*C\u0002\u0002\u0016^\u0014a\u0003T5ti\u001e\u0013x.\u001e9t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0006yF\u0001\r! \u0005\b\u0003\u0013\t\u0002\u0019AAN!\r1\u0018QT\u0005\u0004\u0003?;(!\u0006'jgR<%o\\;qgJ+\u0017/^3ti\u0012\u000bG/Y\u0001\u000fI\u0016\u001c8M]5cK\u001e\u0013x.\u001e9t)\u0019\t)+!0\u0002@B!an]AT!\u0019\tI+a+\u000206\t\u0011/C\u0002\u0002.F\u0014A\u0001T5tiB!\u0011\u0011WA\\\u001d\r1\u00181W\u0005\u0004\u0003k;\u0018A\u0007#fg\u000e\u0014\u0018NY3He>,\bo\u001d*fgB|gn]3ECR\f\u0017\u0002BA]\u0003w\u0013a\u0002R3tGJL'-\u001a3He>,\bOC\u0002\u00026^DQ\u0001 \nA\u0002uDq!!1\u0013\u0001\u0004\t\u0019-\u0001\u0005he>,\b/\u00133t!\u0019\tI+a+\u0002FB!\u0011qYAk\u001d\u0011\tI-!5\u0011\u0007\u0005-w'\u0004\u0002\u0002N*\u0019\u0011q\u001a\u0019\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019nN\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0017\u0011\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Mw'\u0001\u0007eK2,G/Z$s_V\u00048\u000f\u0006\u0005\u0002`\u0006=\u0018\u0011_Az!\u0011q7/!9\u0011\t\u0005\r\u0018\u0011\u001e\b\u0004m\u0006\u0015\u0018bAAto\u0006AB)\u001a7fi\u0016<%o\\;qgJ+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005-\u0018Q\u001e\u0002\u001f\t\u0016dW\r^1cY\u0016<%o\\;q%\u0016\u001cX\u000f\u001c;D_2dWm\u0019;j_:T1!a:x\u0011\u0015a8\u00031\u0001~\u0011\u001d\t\tm\u0005a\u0001\u0003\u0007Dq!a\u0010\u0014\u0001\u0004\t\t%A\bgKR\u001c\u0007.\u00117m\u001f\u001a47/\u001a;t)!\tIP!\u0003\u0003\f\tm\u0001\u0003\u00028t\u0003w\u0004B!!@\u0003\u00049\u0019a/a@\n\u0007\t\u0005q/A\fPM\u001a\u001cX\r\u001e$fi\u000eD'+Z:q_:\u001cX\rR1uC&!!Q\u0001B\u0004\u0005ayeMZ:fi\u001a+Go\u00195SKN\u0004xN\\:f\u000fJ|W\u000f\u001d\u0006\u0004\u0005\u00039\b\"\u0002?\u0015\u0001\u0004i\bbBA\u0005)\u0001\u0007!Q\u0002\t\u0005\u0005\u001f\u0011)BD\u0002w\u0005#I1Aa\u0005x\u0003YyeMZ:fi\u001a+Go\u00195SKF,Xm\u001d;ECR\f\u0017\u0002\u0002B\f\u00053\u0011qc\u00144gg\u0016$h)\u001a;dQJ+\u0017/^3ti\u001e\u0013x.\u001e9\u000b\u0007\tMq\u000f\u0003\u0004\u0003\u001eQ\u0001\r\u0001[\u0001\u000ee\u0016\fX/\u001b:f'R\f'\r\\3\u0002\u0019\u0019,Go\u00195PM\u001a\u001cX\r^:\u0015\u0011\u0005e(1\u0005B\u0013\u0005OAQ\u0001`\u000bA\u0002uDq!!\u0003\u0016\u0001\u0004\u0011i\u0001\u0003\u0004\u0003\u001eU\u0001\r\u0001[\u0001\u0012Q\u0006tG\r\\3GKR\u001c\u0007n\u00144gg\u0016$H\u0003CA}\u0005[\u0011\tDa\r\t\u000f\t=b\u00031\u0001\u0002F\u00069qM]8va&#\u0007B\u0002B\u000f-\u0001\u0007\u0001\u000eC\u0004\u00036Y\u0001\rAa\u000e\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u00037\u0005s\u0011i$C\u0002\u0003<]\u0012aa\u00149uS>t\u0007C\u0002B \u0005\u0013\u0012yE\u0004\u0003\u0003B\t\u0015c\u0002BAf\u0005\u0007J\u0011\u0001O\u0005\u0004\u0005\u000f:\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005\u0017\u0012iEA\u0002TKFT1Aa\u00128!\u0011\u0011\tFa\u0015\u000e\u0003yK1A!\u0016_\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQbY8n[&$xJ\u001a4tKR\u001cH\u0003\u0003B.\u0005G\u0012)G!\u001c\u0011\t9\u001c(Q\f\t\u0004m\n}\u0013b\u0001B1o\nArJ\u001a4tKR\u001cu.\\7jiJ+7\u000f]8og\u0016$\u0015\r^1\t\u000bq<\u0002\u0019A?\t\u000f\u0005%q\u00031\u0001\u0003hA\u0019aO!\u001b\n\u0007\t-tOA\fPM\u001a\u001cX\r^\"p[6LGOU3rk\u0016\u001cH\u000fR1uC\"9\u0011qH\fA\u0002\u0005\u0005\u0013AG2p[6LG\u000f\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cH\u0003\u0003B:\u0005w\u0012iH!\"\u0011\t9\u001c(Q\u000f\t\u0004m\n]\u0014b\u0001B=o\nYB\u000b\u001f8PM\u001a\u001cX\r^\"p[6LGOU3ta>t7/\u001a#bi\u0006DQ\u0001 \rA\u0002uDq!!\u0003\u0019\u0001\u0004\u0011y\bE\u0002w\u0005\u0003K1Aa!x\u0005i!\u0006P\\(gMN,GoQ8n[&$(+Z9vKN$H)\u0019;b\u0011\u001d\ty\u0004\u0007a\u0001\u0003\u0003\nqc\u0019:fCR,wJ\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\u0015\u0019\t-%\u0011\u0013BN\u0005?\u0013IK!,\u0011\u0007)\u0013i)C\u0002\u0003\u0010.\u0013\u0011c\u00144gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b\u0011\u001d\u0011\u0019*\u0007a\u0001\u0005+\u000bQbY;se\u0016tG\u000fV5nK6\u001b\bc\u0001\u001c\u0003\u0018&\u0019!\u0011T\u001c\u0003\t1{gn\u001a\u0005\b\u0005;K\u0002\u0019\u0001BK\u0003\u0019ygMZ:fi\"9!\u0011U\rA\u0002\t\r\u0016a\u00037fC\u0012,'/\u00129pG\"\u00042A\u000eBS\u0013\r\u00119k\u000e\u0002\u0004\u0013:$\bb\u0002BV3\u0001\u0007\u0011QY\u0001\t[\u0016$\u0018\rZ1uC\"9!qV\rA\u0002\tE\u0016aD3ya&\u0014X\rV5nKN$\u0018-\u001c9\u0011\u000bY\u0012ID!&\u0002\u001b\u0011,G.\u001a;f\u001f\u001a47/\u001a;t)!\u00119La0\u0003B\n%\u0007\u0003\u00028t\u0005s\u00032A\u001eB^\u0013\r\u0011il\u001e\u0002\u0019\u001f\u001a47/\u001a;EK2,G/\u001a*fgB|gn]3ECR\f\u0007\"\u0002?\u001b\u0001\u0004i\bbBA\u00055\u0001\u0007!1\u0019\t\u0004m\n\u0015\u0017b\u0001Bdo\n9rJ\u001a4tKR$U\r\\3uKJ+\u0017/^3ti\u0012\u000bG/\u0019\u0005\b\u0003\u007fQ\u0002\u0019AA!\u0003M\u0019w.\u001c9mKR,GK]1og\u0006\u001cG/[8o)9\u0011yMa6\u0003\\\n}'\u0011\u001eBw\u0005o\u0004BA\\:\u0003RB\u0019!Ia5\n\u0007\tU7I\u0001\u0003W_&$\u0007b\u0002Bm7\u0001\u0007!qJ\u0001\u0003iBDqA!8\u001c\u0001\u0004\u0011)*\u0001\u0006qe>$WoY3s\u0013\u0012DqA!9\u001c\u0001\u0004\u0011\u0019/A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0004m\t\u0015\u0018b\u0001Bto\t)1\u000b[8si\"9!1^\u000eA\u0002\t\r\u0016\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011\u001d\u0011yo\u0007a\u0001\u0005c\faA]3tk2$\bc\u0001@\u0003t&\u0019!Q_@\u0003#Q\u0013\u0018M\\:bGRLwN\u001c*fgVdG\u000fC\u0004\u0003zn\u0001\rAa?\u0002\u000fQLW.Z8viB!!Q`B\u0001\u001b\t\u0011yP\u0003\u0002Y\u000b&!11\u0001B\u0000\u0005!!UO]1uS>t\u0017\u0001\u00049beRLG/[8o\r>\u0014H\u0003\u0002BR\u0007\u0013AqAa\f\u001d\u0001\u0004\t)-\u0001\fp]R\u0013\u0018M\\:bGRLwN\\\"p[BdW\r^3e)!\u0011yma\u0004\u0004\u0012\re\u0001b\u0002Bo;\u0001\u0007!Q\u0013\u0005\b\u0005ki\u0002\u0019AB\n!\u0015\u00115Q\u0003B(\u0013\r\u00199b\u0011\u0002\t\u0013R,'/\u00192mK\"911D\u000fA\u0002\tE\u0018!\u0005;sC:\u001c\u0018m\u0019;j_:\u0014Vm];mi\u0006\u0019rN\u001c)beRLG/[8og\u0012+G.\u001a;fIR11\u0011EB\u0014\u0007[\u00012ANB\u0012\u0013\r\u0019)c\u000e\u0002\u0005+:LG\u000fC\u0004\u0004*y\u0001\raa\u000b\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004b!!+\u0002,\n=\u0003bBA =\u0001\u0007\u0011\u0011I\u0001\u000b_:,E.Z2uS>tGCBB\u0011\u0007g\u00199\u0004C\u0004\u00046}\u0001\rAa)\u00027\u001d\u0014x.\u001e9NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:Le\u000eZ3y\u0011\u001d\u0019Id\ba\u0001\u0005G\u000b\u0011e\u001a:pkBlU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"\fQb\u001c8SKNLwM\\1uS>tGCBB\u0011\u0007\u007f\u0019\t\u0005C\u0004\u00046\u0001\u0002\rAa)\t\u000f\re\u0002\u00051\u0001\u0004DA!\u0011\u0011VB#\u0013\r\u00199%\u001d\u0002\f\u001fB$\u0018n\u001c8bY&sG/\u0001\np]:+w/T3uC\u0012\fG/Y%nC\u001e,GCBB\u0011\u0007\u001b\u001ai\u0006C\u0004\u0004P\u0005\u0002\ra!\u0015\u0002\u00119,w/S7bO\u0016\u0004Baa\u0015\u0004Z5\u00111Q\u000b\u0006\u0004\u0007/j\u0015!B5nC\u001e,\u0017\u0002BB.\u0007+\u0012Q\"T3uC\u0012\fG/Y%nC\u001e,\u0007bBB0C\u0001\u00071\u0011M\u0001\u0006I\u0016dG/\u0019\t\u0005\u0007'\u001a\u0019'\u0003\u0003\u0004f\rU#!D'fi\u0006$\u0017\r^1EK2$\u0018-A\rhe>,\b/T3uC\u0012\fG/\u0019+pa&\u001c7i\u001c8gS\u001e\u001cHCAB6!\u0011\tIk!\u001c\n\u0007\r=\u0014O\u0001\u0006Qe>\u0004XM\u001d;jKN\f1b\u001a:pkB\u001cuN\u001c4jOR!1QOBA!\u0019\tIka\u001e\u0004|%\u00191\u0011P9\u0003\u0011=\u0003H/[8oC2\u00042ASB?\u0013\r\u0019yh\u0013\u0002\f\u000fJ|W\u000f]\"p]\u001aLw\rC\u0004\u00030\r\u0002\r!!2\u0002#U\u0004H-\u0019;f\u000fJ|W\u000f]\"p]\u001aLw\r\u0006\u0004\u0004\"\r\u001d5\u0011\u0012\u0005\b\u0005_!\u0003\u0019AAc\u0011\u001d\u0019Y\t\na\u0001\u0007W\naB\\3x\u000fJ|W\u000f]\"p]\u001aLw-A\u0004ti\u0006\u0014H/\u001e9\u0015\t\r\u00052\u0011\u0013\u0005\b\u0007'+\u0003\u0019ABK\u0003\u0001:'o\\;q\u001b\u0016$\u0018\rZ1uCR{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0011\t\r]5QT\u0007\u0003\u00073S1aa'r\u0003!1WO\\2uS>t\u0017\u0002BBP\u00073\u00131\"\u00138u'V\u0004\b\u000f\\5fe\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0004\"\u0005)2m\u001c8tk6,'o\u0012:pkB$Um]2sS\n,GCBBU\u0007s\u001bY\f\u0005\u0003og\u000e-\u0006CBAU\u0003W\u001bi\u000b\u0005\u0003\u00040\u000eUfb\u0001<\u00042&\u001911W<\u0002C\r{gn];nKJ<%o\\;q\t\u0016\u001c8M]5cKJ+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005e6q\u0017\u0006\u0004\u0007g;\b\"\u0002?(\u0001\u0004i\bbBAaO\u0001\u0007\u00111Y\u0001\u0013g\"\f'/Z$s_V\u0004H)Z:de&\u0014W\r\u0006\u0004\u0004B\u000eE71\u001b\t\u0005]N\u001c\u0019\r\u0005\u0004\u0002*\u0006-6Q\u0019\t\u0005\u0007\u000f\u001ciMD\u0002w\u0007\u0013L1aa3x\u0003y\u0019\u0006.\u0019:f\u000fJ|W\u000f\u001d#fg\u000e\u0014\u0018NY3SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002:\u000e='bABfo\")A\u0010\u000ba\u0001{\"9\u0011\u0011\u0019\u0015A\u0002\u0005\r\u0007bBBl\u0007\u0001\u00071\u0011\\\u0001\u0007G>tg-[4\u0011\t\rm7\u0011]\u0007\u0003\u0007;T1aa8/\u0003\u0019\u0019XM\u001d<fe&!11]Bo\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f\r\u001d8\u00011\u0001\u0004j\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0003BBn\u0007WLAa!<\u0004^\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\"\u0002-\u0004\u0001\u0004Q\u0006bBBz\u0007\u0001\u00071Q_\u0001\b[\u0016$(/[2t!\u0011\u00199pa?\u000e\u0005\re(bABz=&!1Q`B}\u0005\u001diU\r\u001e:jGN\u0004")
public class GroupCoordinatorAdapter
implements org.apache.kafka.coordinator.group.GroupCoordinator {
    private final GroupCoordinator coordinator;
    private final Time time;

    public static GroupCoordinatorAdapter apply(KafkaConfig config, ReplicaManager replicaManager, Time time, Metrics metrics) {
        return GroupCoordinatorAdapter$.MODULE$.apply(config, replicaManager, time, metrics);
    }

    private GroupCoordinator coordinator() {
        return this.coordinator;
    }

    private Time time() {
        return this.time;
    }

    public boolean isNewGroupCoordinator() {
        return false;
    }

    public CompletableFuture<ConsumerGroupHeartbeatResponseData> consumerGroupHeartbeat(RequestContext context, ConsumerGroupHeartbeatRequestData request) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception("The old group coordinator does not support " + ApiKeys.CONSUMER_GROUP_HEARTBEAT.name + " API."));
    }

    public CompletableFuture<ShareGroupHeartbeatResponseData> shareGroupHeartbeat(RequestContext context, ShareGroupHeartbeatRequestData request) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception("The old group coordinator does not support " + ApiKeys.SHARE_GROUP_HEARTBEAT.name + " API."));
    }

    public CompletableFuture<JoinGroupResponseData> joinGroup(RequestContext context, JoinGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<JoinGroupResponseData> future = new CompletableFuture<JoinGroupResponseData>();
        Option groupInstanceId = Option$.MODULE$.apply((Object)request.groupInstanceId());
        boolean requireKnownMemberId = context.apiVersion() >= 4 && groupInstanceId.isEmpty();
        List protocols = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(request.protocols().valuesList()).asScala().map((Function1 & Serializable)protocol -> new Tuple2((Object)protocol.name(), (Object)protocol.metadata()))).toList();
        boolean supportSkippingAssignment = context.apiVersion() >= 9;
        this.coordinator().handleJoinGroup(request.groupId(), request.memberId(), (Option<String>)groupInstanceId, requireKnownMemberId, supportSkippingAssignment, context.clientId(), context.clientAddress.toString(), request.rebalanceTimeoutMs(), request.sessionTimeoutMs(), request.protocolType(), (List<Tuple2<String, byte[]>>)protocols, (Function1<JoinGroupResult, BoxedUnit>)(Function1 & Serializable)joinResult -> {
            GroupCoordinatorAdapter.callback$1(joinResult, future);
            return BoxedUnit.UNIT;
        }, (Option<String>)Option$.MODULE$.apply((Object)request.reason()), new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<SyncGroupResponseData> syncGroup(RequestContext context, SyncGroupRequestData request, BufferSupplier bufferSupplier) {
        CompletableFuture<SyncGroupResponseData> future = new CompletableFuture<SyncGroupResponseData>();
        Builder assignmentMap = Map$.MODULE$.newBuilder();
        request.assignments().forEach(assignment -> assignmentMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignment.memberId()), (Object)assignment.assignment())));
        this.coordinator().handleSyncGroup(request.groupId(), request.generationId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.protocolType()), (Option<String>)Option$.MODULE$.apply((Object)request.protocolName()), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), (Map<String, byte[]>)((Map)assignmentMap.result()), (Function1<SyncGroupResult, BoxedUnit>)(Function1 & Serializable)syncGroupResult -> {
            GroupCoordinatorAdapter.callback$2(syncGroupResult, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<HeartbeatResponseData> heartbeat(RequestContext context, HeartbeatRequestData request) {
        CompletableFuture<HeartbeatResponseData> future = new CompletableFuture<HeartbeatResponseData>();
        this.coordinator().handleHeartbeat(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
            future.complete(new HeartbeatResponseData().setErrorCode(error.code()));
            return BoxedUnit.UNIT;
        });
        return future;
    }

    public CompletableFuture<LeaveGroupResponseData> leaveGroup(RequestContext context, LeaveGroupRequestData request) {
        CompletableFuture<LeaveGroupResponseData> future = new CompletableFuture<LeaveGroupResponseData>();
        this.coordinator().handleLeaveGroup(request.groupId(), (List<LeaveGroupRequestData.MemberIdentity>)CollectionConverters$.MODULE$.ListHasAsScala(request.members()).asScala().toList(), (Function1<LeaveGroupResult, BoxedUnit>)(Function1 & Serializable)leaveGroupResult -> {
            GroupCoordinatorAdapter.callback$3(leaveGroupResult, future);
            return BoxedUnit.UNIT;
        });
        return future;
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<ListGroupsResponseData> listGroups(RequestContext context, ListGroupsRequestData request) {
        void var5_5;
        void var4_4;
        Tuple2<Errors, List<GroupOverview>> tuple2 = this.coordinator().handleListGroups((Set<String>)((Set)Option$.MODULE$.apply((Object)request.statesFilter()).map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1).asScala().toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())), (Set<String>)((Set)Option$.MODULE$.apply((Object)request.typesFilter()).map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2).asScala().toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        List groups = (List)tuple2._2();
        ListGroupsResponseData response = new ListGroupsResponseData().setErrorCode(var4_4.code());
        var5_5.foreach((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$listGroups$5(response, group)));
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<java.util.List<DescribeGroupsResponseData.DescribedGroup>> describeGroups(RequestContext context, java.util.List<String> groupIds) {
        return CompletableFuture.completedFuture(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(groupIds).asScala().map((Function1 & Serializable)groupId -> this.describeGroup$1((String)groupId, context))).asJava());
    }

    public CompletableFuture<DeleteGroupsResponseData.DeletableGroupResultCollection> deleteGroups(RequestContext context, java.util.List<String> groupIds, BufferSupplier bufferSupplier) {
        DeleteGroupsResponseData.DeletableGroupResultCollection results = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        this.coordinator().handleDeleteGroups((Set<String>)CollectionConverters$.MODULE$.ListHasAsScala(groupIds).asScala().toSet(), new RequestLocal(bufferSupplier)).foreachEntry((Function2 & Serializable)(groupId, error) -> BoxesRunTime.boxToBoolean((boolean)results.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId).setErrorCode(error.code()))));
        return CompletableFuture.completedFuture(results);
    }

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchAllOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        return this.handleFetchOffset(request.groupId(), requireStable, (Option<scala.collection.immutable.Seq<TopicPartition>>)None$.MODULE$);
    }

    public CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchOffsets(RequestContext context, OffsetFetchRequestData.OffsetFetchRequestGroup request, boolean requireStable) {
        ArrayBuffer topicPartitions = new ArrayBuffer();
        request.topics().forEach(topic -> topic.partitionIndexes().forEach(partition -> topicPartitions.$plus$eq((Object)new TopicPartition(topic.name(), Predef$.MODULE$.Integer2int(partition)))));
        return this.handleFetchOffset(request.groupId(), requireStable, (Option<scala.collection.immutable.Seq<TopicPartition>>)new Some((Object)topicPartitions.toSeq()));
    }

    /*
     * WARNING - void declaration
     */
    private CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> handleFetchOffset(String groupId, boolean requireStable, Option<scala.collection.immutable.Seq<TopicPartition>> partitions) {
        void var5_5;
        Tuple2<Errors, Map<TopicPartition, OffsetFetchResponse.PartitionData>> tuple2 = this.coordinator().handleFetchOffsets(groupId, requireStable, partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Map results = (Map)tuple2._2();
        CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> future = new CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup>();
        void v0 = var5_5;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally((Throwable)var5_5.exception());
        } else {
            void var6_6;
            ArrayList topicsList = new ArrayList();
            HashMap topicsMap = new HashMap();
            var6_6.foreachEntry((Function2 & Serializable)(tp, offset) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$handleFetchOffset$1(topicsMap, topicsList, tp, offset)));
            future.complete(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setTopics(topicsList));
        }
        return future;
    }

    public CompletableFuture<OffsetCommitResponseData> commitOffsets(RequestContext context, OffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<OffsetCommitResponseData> future = new CompletableFuture<OffsetCommitResponseData>();
        long l = request.retentionTimeMs();
        None$ expireTimeMs = -1L == l ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)(currentTimeMs + l)));
        HashMap partitions = new HashMap();
        request.topics().forEach(arg_0 -> GroupCoordinatorAdapter.$anonfun$commitOffsets$2(this, partitions, currentTimeMs, (Option)expireTimeMs, arg_0));
        this.coordinator().handleCommitOffsets(request.groupId(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationIdOrMemberEpoch(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable)commitStatus -> {
            GroupCoordinatorAdapter.callback$4(commitStatus, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier));
        return future;
    }

    public CompletableFuture<TxnOffsetCommitResponseData> commitTransactionalOffsets(RequestContext context, TxnOffsetCommitRequestData request, BufferSupplier bufferSupplier) {
        long currentTimeMs = this.time().milliseconds();
        CompletableFuture<TxnOffsetCommitResponseData> future = new CompletableFuture<TxnOffsetCommitResponseData>();
        HashMap partitions = new HashMap();
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)this.createOffsetAndMetadata(currentTimeMs, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), (Option<Object>)None$.MODULE$)));
        }));
        this.coordinator().handleTxnCommitOffsets(request.groupId(), request.transactionalId(), request.producerId(), request.producerEpoch(), request.memberId(), (Option<String>)Option$.MODULE$.apply((Object)request.groupInstanceId()), request.generationId(), (scala.collection.immutable.Map<TopicIdPartition, OffsetAndMetadata>)partitions.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1<scala.collection.immutable.Map<TopicIdPartition, Errors>, BoxedUnit>)(Function1 & Serializable)results -> {
            GroupCoordinatorAdapter.callback$5(results, future);
            return BoxedUnit.UNIT;
        }, new RequestLocal(bufferSupplier), context.apiVersion());
        return future;
    }

    private OffsetAndMetadata createOffsetAndMetadata(long currentTimeMs, long offset, int leaderEpoch, String metadata, Option<Object> expireTimestamp) {
        OptionalLong optionalLong;
        OptionalInt optionalInt = switch (leaderEpoch) {
            case -1 -> OptionalInt.empty();
            default -> OptionalInt.of(leaderEpoch);
        };
        String string = switch (metadata == null ? 0 : metadata.hashCode()) {
            case 0 -> {
                if (metadata == null) {
                    yield "";
                }
            }
            default -> metadata;
        };
        if (expireTimestamp instanceof Some) {
            optionalLong = OptionalLong.of(BoxesRunTime.unboxToLong((Object)((Some)expireTimestamp).value()));
        } else if (None$.MODULE$.equals(expireTimestamp)) {
            optionalLong = OptionalLong.empty();
        } else {
            throw new MatchError(expireTimestamp);
        }
        return new OffsetAndMetadata(offset, optionalInt, string, currentTimeMs, optionalLong);
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<OffsetDeleteResponseData> deleteOffsets(RequestContext context, OffsetDeleteRequestData request, BufferSupplier bufferSupplier) {
        void var7_7;
        CompletableFuture<OffsetDeleteResponseData> future = new CompletableFuture<OffsetDeleteResponseData>();
        ArrayBuffer partitions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        request.topics().forEach(topic -> topic.partitions().forEach(partition -> partitions.$plus$eq((Object)new TopicPartition(topic.name(), partition.partitionIndex()))));
        Tuple2<Errors, Map<TopicPartition, Errors>> tuple2 = this.coordinator().handleDeleteOffsets(request.groupId(), (Seq<TopicPartition>)partitions, new RequestLocal(bufferSupplier));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors groupError = (Errors)tuple2._1();
        Map topicPartitionResults = (Map)tuple2._2();
        void v0 = var7_7;
        Errors errors = Errors.NONE;
        if (v0 == null ? errors != null : !v0.equals(errors)) {
            future.completeExceptionally((Throwable)var7_7.exception());
        } else {
            void var8_8;
            OffsetDeleteResponseData response = new OffsetDeleteResponseData();
            var8_8.foreachEntry((Function2 & Serializable)(topicPartition, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$deleteOffsets$3(response, topicPartition, error)));
            future.complete(response);
        }
        return future;
    }

    public CompletableFuture<Void> completeTransaction(TopicPartition tp, long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result, Duration timeout) {
        return FutureUtils.failedFuture((Throwable)new IllegalStateException("The old group coordinator does not support `completeTransaction` API."));
    }

    public int partitionFor(String groupId) {
        return this.coordinator().partitionFor(groupId);
    }

    public CompletableFuture<Void> onTransactionCompleted(long producerId, java.lang.Iterable<TopicPartition> partitions, TransactionResult transactionResult) {
        try {
            return this.coordinator().scheduleHandleTxnCompletion(producerId, (Iterable<TopicPartition>)CollectionConverters$.MODULE$.IterableHasAsScala(partitions).asScala(), transactionResult);
        }
        catch (Throwable throwable) {
            return FutureUtils.failedFuture((Throwable)throwable);
        }
    }

    public void onPartitionsDeleted(java.util.List<TopicPartition> topicPartitions, BufferSupplier bufferSupplier) {
        this.coordinator().handleDeletedPartitions((Seq<TopicPartition>)CollectionConverters$.MODULE$.ListHasAsScala(topicPartitions).asScala(), new RequestLocal(bufferSupplier));
    }

    public void onElection(int groupMetadataPartitionIndex, int groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onElection(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onResignation(int groupMetadataPartitionIndex, OptionalInt groupMetadataPartitionLeaderEpoch) {
        this.coordinator().onResignation(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch);
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
    }

    public Properties groupMetadataTopicConfigs() {
        return this.coordinator().offsetsTopicConfigs();
    }

    public Optional<GroupConfig> groupConfig(String groupId) {
        throw Errors.UNSUPPORTED_VERSION.exception("The old group coordinator does not support get group config.");
    }

    public void updateGroupConfig(String groupId, Properties newGroupConfig) {
        throw Errors.UNSUPPORTED_VERSION.exception("The old group coordinator does not support update group config.");
    }

    public void startup(IntSupplier groupMetadataTopicPartitionCount) {
        this.coordinator().startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> groupMetadataTopicPartitionCount.getAsInt(), this.coordinator().startup$default$2());
    }

    public void shutdown() {
        this.coordinator().shutdown();
    }

    public CompletableFuture<java.util.List<ConsumerGroupDescribeResponseData.DescribedGroup>> consumerGroupDescribe(RequestContext context, java.util.List<String> groupIds) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception("The old group coordinator does not support " + ApiKeys.CONSUMER_GROUP_DESCRIBE.name + " API."));
    }

    public CompletableFuture<java.util.List<ShareGroupDescribeResponseData.DescribedGroup>> shareGroupDescribe(RequestContext context, java.util.List<String> groupIds) {
        return FutureUtils.failedFuture((Throwable)Errors.UNSUPPORTED_VERSION.exception("The old group coordinator does not support " + ApiKeys.SHARE_GROUP_DESCRIBE.name + " API."));
    }

    private static final void callback$1(JoinGroupResult joinResult, CompletableFuture future$1) {
        future$1.complete(new JoinGroupResponseData().setErrorCode(joinResult.error().code()).setGenerationId(joinResult.generationId()).setProtocolType((String)joinResult.protocolType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setProtocolName((String)joinResult.protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setLeader(joinResult.leaderId()).setSkipAssignment(joinResult.skipAssignment()).setMemberId(joinResult.memberId()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava(joinResult.members()).asJava()));
    }

    private static final void callback$2(SyncGroupResult syncGroupResult, CompletableFuture future$2) {
        future$2.complete(new SyncGroupResponseData().setErrorCode(syncGroupResult.error().code()).setProtocolType((String)syncGroupResult.protocolType().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setProtocolName((String)syncGroupResult.protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setAssignment(syncGroupResult.memberAssignment()));
    }

    private static final void callback$3(LeaveGroupResult leaveGroupResult, CompletableFuture future$4) {
        future$4.complete(new LeaveGroupResponseData().setErrorCode(leaveGroupResult.topLevelError().code()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaveGroupResult.memberResponses().map((Function1 & Serializable)member -> new LeaveGroupResponseData.MemberResponse().setErrorCode(member.error().code()).setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())))).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$listGroups$5(ListGroupsResponseData response$1, GroupOverview group) {
        return response$1.groups().add(new ListGroupsResponseData.ListedGroup().setGroupId(group.groupId()).setProtocolType(group.protocolType()).setGroupState(group.state()).setGroupType(group.groupType()));
    }

    /*
     * WARNING - void declaration
     */
    private final DescribeGroupsResponseData.DescribedGroup describeGroup$1(String groupId, RequestContext context$1) {
        void var6_6;
        void var5_5;
        void var4_4;
        Tuple3<Errors, Option<String>, GroupSummary> tuple3 = this.coordinator().handleDescribeGroup(groupId, context$1.apiVersion());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple3._1();
        Option errorMessage = (Option)tuple3._2();
        GroupSummary summary = (GroupSummary)tuple3._3();
        return new DescribeGroupsResponseData.DescribedGroup().setErrorCode(var4_4.code()).setErrorMessage((String)var5_5.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setGroupId(groupId).setGroupState(var6_6.state()).setProtocolType(var6_6.protocolType()).setProtocolData(var6_6.protocol()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)var6_6.members().map((Function1 & Serializable)member -> new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(member.memberId()).setGroupInstanceId((String)member.groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setClientId(member.clientId()).setClientHost(member.clientHost()).setMemberAssignment(member.assignment()).setMemberMetadata(member.metadata()))).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$handleFetchOffset$1(HashMap topicsMap$1, ArrayList topicsList$1, TopicPartition tp, OffsetFetchResponse.PartitionData offset) {
        OffsetFetchResponseData.OffsetFetchResponseTopics offsetFetchResponseTopics;
        Option option = topicsMap$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetFetchResponseTopics = (OffsetFetchResponseData.OffsetFetchResponseTopics)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetFetchResponseData.OffsetFetchResponseTopics topicOffsets = new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(tp.topic());
            topicsMap$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)topicOffsets));
            topicsList$1.add(topicOffsets);
            offsetFetchResponseTopics = topicOffsets;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetFetchResponseTopics.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(tp.partition()).setMetadata(offset.metadata).setCommittedOffset(offset.offset).setCommittedLeaderEpoch(Predef$.MODULE$.Integer2int(offset.leaderEpoch.orElse(Predef$.MODULE$.int2Integer(-1)))).setErrorCode(offset.error.code()));
    }

    public static final /* synthetic */ boolean $anonfun$commitOffsets$1(HashMap byTopics$1, OffsetCommitResponseData response$2, TopicIdPartition tp, Errors error) {
        OffsetCommitResponseData.OffsetCommitResponseTopic offsetCommitResponseTopic;
        Option option = byTopics$1.get((Object)tp.topic());
        if (option instanceof Some) {
            offsetCommitResponseTopic = (OffsetCommitResponseData.OffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            OffsetCommitResponseData.OffsetCommitResponseTopic newTopic = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(tp.topic());
            byTopics$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$2.topics().add(newTopic);
            offsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return offsetCommitResponseTopic.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    private static final void callback$4(scala.collection.immutable.Map commitStatus, CompletableFuture future$5) {
        OffsetCommitResponseData response = new OffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        commitStatus.foreachEntry((Function2 & Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitOffsets$1(byTopics, response, tp, error)));
        future$5.complete(response);
    }

    public static final /* synthetic */ void $anonfun$commitOffsets$2(GroupCoordinatorAdapter $this, HashMap partitions$1, long currentTimeMs$1, Option expireTimeMs$1, OffsetCommitRequestData.OffsetCommitRequestTopic topic) {
        topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(Uuid.ZERO_UUID, partition.partitionIndex(), topic.name());
            partitions$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)$this.createOffsetAndMetadata(currentTimeMs$1, partition.committedOffset(), partition.committedLeaderEpoch(), partition.committedMetadata(), (Option<Object>)expireTimeMs$1)));
        });
    }

    public static final /* synthetic */ boolean $anonfun$commitTransactionalOffsets$1(HashMap byTopics$2, TxnOffsetCommitResponseData response$3, TopicIdPartition tp, Errors error) {
        TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic txnOffsetCommitResponseTopic;
        Option option = byTopics$2.get((Object)tp.topic());
        if (option instanceof Some) {
            txnOffsetCommitResponseTopic = (TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic newTopic = new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(tp.topic());
            byTopics$2.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)newTopic));
            response$3.topics().add(newTopic);
            txnOffsetCommitResponseTopic = newTopic;
        } else {
            throw new MatchError((Object)option);
        }
        return txnOffsetCommitResponseTopic.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(tp.partition()).setErrorCode(error.code()));
    }

    private static final void callback$5(scala.collection.immutable.Map results, CompletableFuture future$6) {
        TxnOffsetCommitResponseData response = new TxnOffsetCommitResponseData();
        HashMap byTopics = new HashMap();
        results.foreachEntry((Function2 & Serializable)(tp, error) -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorAdapter.$anonfun$commitTransactionalOffsets$1(byTopics, response, tp, error)));
        future$6.complete(response);
    }

    public static final /* synthetic */ boolean $anonfun$deleteOffsets$3(OffsetDeleteResponseData response$4, TopicPartition topicPartition, Errors error) {
        OffsetDeleteResponseData.OffsetDeleteResponseTopic topic = response$4.topics().find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topicPartition.topic());
            response$4.topics().add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(topicPartition.partition()).setErrorCode(error.code()));
    }

    public GroupCoordinatorAdapter(GroupCoordinator coordinator, Time time) {
        this.coordinator = coordinator;
        this.time = time;
    }
}

