/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.ShareGroupAutoOffsetResetStrategy;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupConfig;

public final class GroupConfig
extends AbstractConfig {
    public static final String CONSUMER_SESSION_TIMEOUT_MS_CONFIG = "consumer.session.timeout.ms";
    public static final String CONSUMER_HEARTBEAT_INTERVAL_MS_CONFIG = "consumer.heartbeat.interval.ms";
    public static final String SHARE_SESSION_TIMEOUT_MS_CONFIG = "share.session.timeout.ms";
    public static final String SHARE_HEARTBEAT_INTERVAL_MS_CONFIG = "share.heartbeat.interval.ms";
    public static final String SHARE_RECORD_LOCK_DURATION_MS_CONFIG = "share.record.lock.duration.ms";
    public static final String SHARE_AUTO_OFFSET_RESET_CONFIG = "share.auto.offset.reset";
    public static final String SHARE_AUTO_OFFSET_RESET_DEFAULT = ShareGroupAutoOffsetResetStrategy.LATEST.name();
    public static final String SHARE_AUTO_OFFSET_RESET_DOC = "The strategy to initialize the share-partition start offset. <ul><li>earliest: automatically reset the offset to the earliest offset</li><li>latest: automatically reset the offset to the latest offset</li><li>by_duration:&lt;duration&gt;: automatically reset the offset to a configured duration from the current timestamp. &lt;duration&gt; must be specified in ISO8601 format (PnDTnHnMn.nS). Negative duration is not allowed.</li><li>anything else: throw exception to the share consumer.</li></ul>";
    public final int consumerSessionTimeoutMs = this.getInt("consumer.session.timeout.ms");
    public final int consumerHeartbeatIntervalMs = this.getInt("consumer.heartbeat.interval.ms");
    public final int shareSessionTimeoutMs = this.getInt("share.session.timeout.ms");
    public final int shareHeartbeatIntervalMs = this.getInt("share.heartbeat.interval.ms");
    public final int shareRecordLockDurationMs = this.getInt("share.record.lock.duration.ms");
    public final String shareAutoOffsetReset = this.getString("share.auto.offset.reset");
    private static final ConfigDef CONFIG = new ConfigDef().define("consumer.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The timeout to detect client failures when using the consumer group protocol.").define("consumer.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The heartbeat interval given to the members of a consumer group.").define("share.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The timeout to detect client failures when using the share group protocol.").define("share.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The heartbeat interval given to the members of a share group.").define("share.record.lock.duration.ms", ConfigDef.Type.INT, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1000), ConfigDef.Importance.MEDIUM, "The record acquisition lock duration in milliseconds for share groups.").define("share.auto.offset.reset", ConfigDef.Type.STRING, (Object)SHARE_AUTO_OFFSET_RESET_DEFAULT, (ConfigDef.Validator)new ShareGroupAutoOffsetResetStrategy.Validator(), ConfigDef.Importance.MEDIUM, "The strategy to initialize the share-partition start offset. <ul><li>earliest: automatically reset the offset to the earliest offset</li><li>latest: automatically reset the offset to the latest offset</li><li>by_duration:&lt;duration&gt;: automatically reset the offset to a configured duration from the current timestamp. &lt;duration&gt; must be specified in ISO8601 format (PnDTnHnMn.nS). Negative duration is not allowed.</li><li>anything else: throw exception to the share consumer.</li></ul>");

    public GroupConfig(Map<?, ?> props) {
        super(CONFIG, props, false);
    }

    public static ConfigDef configDef() {
        return CONFIG;
    }

    public static Optional<ConfigDef.Type> configType(String configName) {
        return Optional.ofNullable((ConfigDef.ConfigKey)CONFIG.configKeys().get(configName)).map(c -> c.type);
    }

    public static Set<String> configNames() {
        return CONFIG.names();
    }

    public static void validateNames(Properties props) {
        Set<String> names = GroupConfig.configNames();
        for (Object name : props.keySet()) {
            if (names.contains(name)) continue;
            throw new InvalidConfigurationException("Unknown group config name: " + String.valueOf(name));
        }
    }

    private static void validateValues(Map<?, ?> valueMaps, GroupCoordinatorConfig groupCoordinatorConfig, ShareGroupConfig shareGroupConfig) {
        int consumerHeartbeatInterval = (Integer)valueMaps.get(CONSUMER_HEARTBEAT_INTERVAL_MS_CONFIG);
        int consumerSessionTimeout = (Integer)valueMaps.get(CONSUMER_SESSION_TIMEOUT_MS_CONFIG);
        int shareHeartbeatInterval = (Integer)valueMaps.get(SHARE_HEARTBEAT_INTERVAL_MS_CONFIG);
        int shareSessionTimeout = (Integer)valueMaps.get(SHARE_SESSION_TIMEOUT_MS_CONFIG);
        int shareRecordLockDurationMs = (Integer)valueMaps.get(SHARE_RECORD_LOCK_DURATION_MS_CONFIG);
        if (consumerHeartbeatInterval < groupCoordinatorConfig.consumerGroupMinHeartbeatIntervalMs()) {
            throw new InvalidConfigurationException("consumer.heartbeat.interval.ms must be greater than or equal to group.consumer.min.heartbeat.interval.ms");
        }
        if (consumerHeartbeatInterval > groupCoordinatorConfig.consumerGroupMaxHeartbeatIntervalMs()) {
            throw new InvalidConfigurationException("consumer.heartbeat.interval.ms must be less than or equal to group.consumer.max.heartbeat.interval.ms");
        }
        if (consumerSessionTimeout < groupCoordinatorConfig.consumerGroupMinSessionTimeoutMs()) {
            throw new InvalidConfigurationException("consumer.session.timeout.ms must be greater than or equal to group.consumer.min.session.timeout.ms");
        }
        if (consumerSessionTimeout > groupCoordinatorConfig.consumerGroupMaxSessionTimeoutMs()) {
            throw new InvalidConfigurationException("consumer.session.timeout.ms must be less than or equal to group.consumer.max.session.timeout.ms");
        }
        if (shareHeartbeatInterval < groupCoordinatorConfig.shareGroupMinHeartbeatIntervalMs()) {
            throw new InvalidConfigurationException("share.heartbeat.interval.ms must be greater than or equal to group.share.min.heartbeat.interval.ms");
        }
        if (shareHeartbeatInterval > groupCoordinatorConfig.shareGroupMaxHeartbeatIntervalMs()) {
            throw new InvalidConfigurationException("share.heartbeat.interval.ms must be less than or equal to group.share.max.heartbeat.interval.ms");
        }
        if (shareSessionTimeout < groupCoordinatorConfig.shareGroupMinSessionTimeoutMs()) {
            throw new InvalidConfigurationException("share.session.timeout.ms must be greater than or equal to group.share.min.session.timeout.ms");
        }
        if (shareSessionTimeout > groupCoordinatorConfig.shareGroupMaxSessionTimeoutMs()) {
            throw new InvalidConfigurationException("share.session.timeout.ms must be less than or equal to group.share.max.session.timeout.ms");
        }
        if (shareRecordLockDurationMs < shareGroupConfig.shareGroupMinRecordLockDurationMs()) {
            throw new InvalidConfigurationException("share.record.lock.duration.ms must be greater than or equal to group.share.min.record.lock.duration.ms");
        }
        if (shareRecordLockDurationMs > shareGroupConfig.shareGroupMaxRecordLockDurationMs()) {
            throw new InvalidConfigurationException("share.record.lock.duration.ms must be less than or equal to group.share.max.record.lock.duration.ms");
        }
        if (consumerSessionTimeout <= consumerHeartbeatInterval) {
            throw new InvalidConfigurationException("consumer.session.timeout.ms must be greater than consumer.heartbeat.interval.ms");
        }
        if (shareSessionTimeout <= shareHeartbeatInterval) {
            throw new InvalidConfigurationException("share.session.timeout.ms must be greater than share.heartbeat.interval.ms");
        }
    }

    public static void validate(Properties props, GroupCoordinatorConfig groupCoordinatorConfig, ShareGroupConfig shareGroupConfig) {
        GroupConfig.validateNames(props);
        Map valueMaps = CONFIG.parse((Map)props);
        GroupConfig.validateValues(valueMaps, groupCoordinatorConfig, shareGroupConfig);
    }

    public static GroupConfig fromProps(Map<?, ?> defaults, Properties overrides) {
        Properties props = new Properties();
        props.putAll(defaults);
        props.putAll((Map<?, ?>)overrides);
        return new GroupConfig(props);
    }

    public static ShareGroupAutoOffsetResetStrategy defaultShareAutoOffsetReset() {
        return ShareGroupAutoOffsetResetStrategy.fromString(SHARE_AUTO_OFFSET_RESET_DEFAULT);
    }

    public int consumerSessionTimeoutMs() {
        return this.consumerSessionTimeoutMs;
    }

    public int consumerHeartbeatIntervalMs() {
        return this.consumerHeartbeatIntervalMs;
    }

    public int shareSessionTimeoutMs() {
        return this.shareSessionTimeoutMs;
    }

    public int shareHeartbeatIntervalMs() {
        return this.shareHeartbeatIntervalMs;
    }

    public int shareRecordLockDurationMs() {
        return this.shareRecordLockDurationMs;
    }

    public ShareGroupAutoOffsetResetStrategy shareAutoOffsetReset() {
        return ShareGroupAutoOffsetResetStrategy.fromString(this.shareAutoOffsetReset);
    }
}

