/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.NamedOperation;
import org.apache.kafka.streams.processor.StreamPartitioner;

public class Repartitioned<K, V>
implements NamedOperation<Repartitioned<K, V>> {
    protected final String name;
    protected final Serde<K> keySerde;
    protected final Serde<V> valueSerde;
    protected final Integer numberOfPartitions;
    protected final StreamPartitioner<K, V> partitioner;

    private Repartitioned(String name, Serde<K> keySerde, Serde<V> valueSerde, Integer numberOfPartitions, StreamPartitioner<K, V> partitioner) {
        this.name = name;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.numberOfPartitions = numberOfPartitions;
        this.partitioner = partitioner;
    }

    protected Repartitioned(Repartitioned<K, V> repartitioned) {
        this(repartitioned.name, repartitioned.keySerde, repartitioned.valueSerde, repartitioned.numberOfPartitions, repartitioned.partitioner);
    }

    public static <K, V> Repartitioned<K, V> as(String name) {
        return new Repartitioned<K, V>(name, null, null, null, null);
    }

    public static <K, V> Repartitioned<K, V> with(Serde<K> keySerde, Serde<V> valueSerde) {
        return new Repartitioned<K, V>(null, keySerde, valueSerde, null, null);
    }

    public static <K, V> Repartitioned<K, V> streamPartitioner(StreamPartitioner<K, V> partitioner) {
        return new Repartitioned<K, V>(null, null, null, null, partitioner);
    }

    public static <K, V> Repartitioned<K, V> numberOfPartitions(int numberOfPartitions) {
        return new Repartitioned<K, V>(null, null, null, numberOfPartitions, null);
    }

    @Override
    public Repartitioned<K, V> withName(String name) {
        return new Repartitioned<K, V>(name, this.keySerde, this.valueSerde, this.numberOfPartitions, this.partitioner);
    }

    public Repartitioned<K, V> withNumberOfPartitions(int numberOfPartitions) {
        return new Repartitioned<K, V>(this.name, this.keySerde, this.valueSerde, numberOfPartitions, this.partitioner);
    }

    public Repartitioned<K, V> withKeySerde(Serde<K> keySerde) {
        return new Repartitioned<K, V>(this.name, keySerde, this.valueSerde, this.numberOfPartitions, this.partitioner);
    }

    public Repartitioned<K, V> withValueSerde(Serde<V> valueSerde) {
        return new Repartitioned<K, V>(this.name, this.keySerde, valueSerde, this.numberOfPartitions, this.partitioner);
    }

    public Repartitioned<K, V> withStreamPartitioner(StreamPartitioner<K, V> partitioner) {
        return new Repartitioned<K, V>(this.name, this.keySerde, this.valueSerde, this.numberOfPartitions, partitioner);
    }
}

