/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.network.TooManyConnectionsException;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011=bAB0a\u0003\u0003\u0011G\r\u0003\u0005w\u0001\t\u0015\r\u0011\"\u0001y\u0011!i\bA!A!\u0002\u0013I\b\u0002\u0003@\u0001\u0005\u000b\u0007I\u0011A@\t\u0015\u00055\u0001A!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\u0010\u0001\u0011\t\u0019!C\u0001\u0003#A!\"a\b\u0001\u0005\u0003\u0007I\u0011AA\u0011\u0011)\t\u0019\u0004\u0001B\u0001B\u0003&\u00111\u0003\u0005\u000b\u0003k\u0001!\u0011!Q\u0001\n\u0005]\u0002BCA\u001f\u0001\t\u0015\r\u0011\"\u0001\u0002@!Q\u0011q\t\u0001\u0003\u0002\u0003\u0006I!!\u0011\t\u0015\u0005%\u0003A!A!\u0002\u0013\tY\u0005\u0003\u0006\u0002d\u0001\u0011\t\u0011)A\u0005\u0003KB!\"a\u001b\u0001\u0005\u0003\u0005\u000b\u0011BA7\u0011)\t\u0019\b\u0001B\u0001B\u0003%\u0011Q\u000f\u0005\u000b\u0003\u007f\u0002!\u0011!Q\u0001\n\u0005\u0005\u0005BCAG\u0001\t\u0005\t\u0015!\u0003\u0002\u0010\"Q\u0011Q\u0013\u0001\u0003\u0002\u0003\u0006I!a&\t\u0015\u0005\r\u0006A!A!\u0002\u0013\t)\u000bC\u0004\u0002,\u0002!\t!!,\t\u0013\u0005-\u0007A1A\u0005\n\u00055\u0007\u0002CAn\u0001\u0001\u0006I!a4\t\u0013\u0005u\u0007A1A\u0005\u0002\u0005}\u0007\u0002CA{\u0001\u0001\u0006I!!9\t\u000f\u0005]\bA\"\u0001\u0002z\"9!\u0011\u0003\u0001\u0007\u0002\u0005e\b\"\u0003B\n\u0001\t\u0007I\u0011\u0002B\u000b\u0011!\u0011i\u0002\u0001Q\u0001\n\t]\u0001\"\u0003B\u0010\u0001\t\u0007I\u0011\u0002B\u000b\u0011!\u0011\t\u0003\u0001Q\u0001\n\t]\u0001\"\u0003B\u0012\u0001\t\u0007I\u0011\u0002B\u000b\u0011!\u0011)\u0003\u0001Q\u0001\n\t]\u0001\"\u0003B\u0014\u0001\t\u0007I\u0011\u0002B\u0015\u0011!\u0011Y\u0004\u0001Q\u0001\n\t-\u0002\u0002\u0004B\u001f\u0001\u0001\u0007\t\u0019!C\u0001A\n}\u0002\u0002\u0004B$\u0001\u0001\u0007\t\u0019!C\u0001A\n%\u0003b\u0003B'\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0003B!Ba\u0014\u0001\u0005\u0004%\t\u0001\u0019B)\u0011!\u0011\u0019\u0006\u0001Q\u0001\n\u0005]\u0002B\u0003B+\u0001\t\u0007I\u0011\u00011\u0003X!A!q\u000e\u0001!\u0002\u0013\u0011I\u0006C\u0005\u0003r\u0001\u0011\r\u0011\"\u0003\u0003t!A!1\u0012\u0001!\u0002\u0013\u0011)\bC\u0005\u0003\u000e\u0002\u0011\r\u0011\"\u0003\u0003\u0010\"A!q\u0013\u0001!\u0002\u0013\u0011\t\nC\u0005\u0003\u001a\u0002\u0001\r\u0011\"\u0003\u0003R!I!1\u0014\u0001A\u0002\u0013%!Q\u0014\u0005\t\u0005C\u0003\u0001\u0015)\u0003\u00028!Q!1\u0015\u0001C\u0002\u0013\u0005\u0001M!*\t\u0011\rm\u0003\u0001)A\u0005\u0005OC\u0011b!\u0018\u0001\u0005\u0004%I!a8\t\u0011\r}\u0003\u0001)A\u0005\u0003CD!b!\u0019\u0001\u0005\u0004%\t\u0001YB2\u0011!\u0019\u0019\b\u0001Q\u0001\n\r\u0015\u0004\"CB;\u0001\t\u0007I\u0011AB<\u0011!\u0019y\b\u0001Q\u0001\n\re\u0004bBBA\u0001\u0011\u000511\u0011\u0004\b\u0005c\u0003\u0001\t\u0019BZ\u0011)\u0011I.\u000fBK\u0002\u0013\u0005!1\u001c\u0005\u000b\u0005GL$\u0011#Q\u0001\n\tu\u0007B\u0003Bss\tU\r\u0011\"\u0001\u0003h\"Q!q^\u001d\u0003\u0012\u0003\u0006IA!;\t\u000f\u0005-\u0016\b\"\u0001\u0003r\"9!q_\u001d\u0005B\te\b\"\u0003B\u0000s\u0005\u0005I\u0011AB\u0001\u0011%\u00199!OI\u0001\n\u0003\u0019I\u0001C\u0005\u0004 e\n\n\u0011\"\u0001\u0004\"!I1QE\u001d\u0002\u0002\u0013\u00053q\u0005\u0005\n\u0007[I\u0014\u0011!C\u0001\u0005#B\u0011ba\f:\u0003\u0003%\ta!\r\t\u0013\rm\u0012(!A\u0005B\ru\u0002\"CB$s\u0005\u0005I\u0011AB%\u0011%\u0019i%OA\u0001\n\u0003\u001ay\u0005C\u0005\u0004Re\n\t\u0011\"\u0011\u0004T!I1QK\u001d\u0002\u0002\u0013\u00053qK\u0004\u000b\u0007\u000b\u0003\u0011\u0011!E\u0001A\u000e\u001deA\u0003BY\u0001\u0005\u0005\t\u0012\u00011\u0004\n\"9\u00111\u0016'\u0005\u0002\r]\u0005\"CB)\u0019\u0006\u0005IQIB*\u0011%\u0019I\nTA\u0001\n\u0003\u001bY\nC\u0005\u0004\"2\u000b\t\u0011\"!\u0004$\"A1Q\u0017\u0001\u0005\u0002\u0001\u001c9\fC\u0004\u0004>\u0002!\taa!\t\u000f\r}\u0006\u0001\"\u0001\u0004\u0004\"91\u0011\u0019\u0001\u0005B\r\r\u0005bBBb\u0001\u0011%11\u0011\u0005\b\u0007\u000b\u0004A\u0011BBd\u0011\u001d\u0019\u0019\u000e\u0001C\u0005\u0007\u0007Cqa!6\u0001\t\u0013\u00199\u000eC\u0004\u0004f\u0002!\tba:\t\u000f\r5\b\u0001\"\u0003\u0004\u0004\"91q\u001e\u0001\u0005\n\rE\bbBB\u007f\u0001\u0011\u000511\u0011\u0005\b\u0007\u007f\u0004A\u0011\u0001C\u0001\u0011\u001d!9\u0001\u0001C\u0001\t\u0013\u0011\u0001\"Q2dKB$xN\u001d\u0006\u0003C\n\fqA\\3uo>\u00148NC\u0001d\u0003\u0015Y\u0017MZ6b'\u0011\u0001Q-\u001c9\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017\u0001\u00027b]\u001eT\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\n1qJ\u00196fGR\u0004\"A\u001a8\n\u0005=<'\u0001\u0003*v]:\f'\r\\3\u0011\u0005E$X\"\u0001:\u000b\u0005M\u0014\u0017!B;uS2\u001c\u0018BA;s\u0005\u001daunZ4j]\u001e\fAb]8dW\u0016$8+\u001a:wKJ\u001c\u0001!F\u0001z!\tQ80D\u0001a\u0013\ta\bM\u0001\u0007T_\u000e\\W\r^*feZ,'/A\u0007t_\u000e\\W\r^*feZ,'\u000fI\u0001\tK:$\u0007k\\5oiV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u00012\u0002\u000f\rdWo\u001d;fe&!\u00111BA\u0003\u0005!)e\u000e\u001a)pS:$\u0018!C3oIB{\u0017N\u001c;!\u0003\u0019\u0019wN\u001c4jOV\u0011\u00111\u0003\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u00042\u0002\rM,'O^3s\u0013\u0011\ti\"a\u0006\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA\u0012\u0003_\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0003\u0003S\tQa]2bY\u0006LA!!\f\u0002(\t!QK\\5u\u0011%\t\tDBA\u0001\u0002\u0004\t\u0019\"A\u0002yIE\nqaY8oM&<\u0007%\u0001\u0004o_\u0012,\u0017\n\u001a\t\u0005\u0003K\tI$\u0003\u0003\u0002<\u0005\u001d\"aA%oi\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u000b\u0003\u0003\u0003\u00022A_A\"\u0013\r\t)\u0005\u0019\u0002\u0011\u0007>tg.Z2uS>t\u0017+^8uCN\f\u0011cY8o]\u0016\u001cG/[8o#V|G/Y:!\u0003\u0011!\u0018.\\3\u0011\t\u00055\u0013qL\u0007\u0003\u0003\u001fR1a]A)\u0015\u0011\t\u0019&!\u0016\u0002\r\r|W.\\8o\u0015\r\u0019\u0017q\u000b\u0006\u0005\u00033\nY&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003;\n1a\u001c:h\u0013\u0011\t\t'a\u0014\u0003\tQKW.Z\u0001\u0015SN\u0004&/\u001b<jY\u0016<W\r\u001a'jgR,g.\u001a:\u0011\t\u0005\u0015\u0012qM\u0005\u0005\u0003S\n9CA\u0004C_>dW-\u00198\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB\u0019!0a\u001c\n\u0007\u0005E\u0004M\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002\u000f5,GO]5dgB!\u0011qOA>\u001b\t\tIH\u0003\u0003\u0002t\u0005E\u0013\u0002BA?\u0003s\u0012q!T3ue&\u001c7/\u0001\nde\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\b\u0003BAB\u0003\u0013k!!!\"\u000b\t\u0005\u001d\u0015QK\u0001\tg\u0016\u001cWO]5us&!\u00111RAC\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0002\u00151|wmQ8oi\u0016DH\u000f\u0005\u0003\u0002N\u0005E\u0015\u0002BAJ\u0003\u001f\u0012!\u0002T8h\u0007>tG/\u001a=u\u0003)iW-\\8ssB{w\u000e\u001c\t\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*!\u0011QTA)\u0003\u0019iW-\\8ss&!\u0011\u0011UAN\u0005)iU-\\8ssB{w\u000e\\\u0001\u0012CBLg+\u001a:tS>tW*\u00198bO\u0016\u0014\b\u0003BA\u000b\u0003OKA!!+\u0002\u0018\t\t\u0012\t]5WKJ\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002\rqJg.\u001b;?)q\ty+!-\u00024\u0006U\u0016qWA]\u0003w\u000bi,a0\u0002B\u0006\r\u0017QYAd\u0003\u0013\u0004\"A\u001f\u0001\t\u000bY\u001c\u0002\u0019A=\t\ry\u001c\u0002\u0019AA\u0001\u0011\u001d\tya\u0005a\u0001\u0003'Aq!!\u000e\u0014\u0001\u0004\t9\u0004C\u0004\u0002>M\u0001\r!!\u0011\t\u000f\u0005%3\u00031\u0001\u0002L!9\u00111M\nA\u0002\u0005\u0015\u0004bBA6'\u0001\u0007\u0011Q\u000e\u0005\b\u0003g\u001a\u0002\u0019AA;\u0011\u001d\tyh\u0005a\u0001\u0003\u0003Cq!!$\u0014\u0001\u0004\ty\tC\u0004\u0002\u0016N\u0001\r!a&\t\u000f\u0005\r6\u00031\u0001\u0002&\u0006aQ.\u001a;sS\u000e\u001cxI]8vaV\u0011\u0011q\u001a\t\u0005\u0003#\f9.\u0004\u0002\u0002T*!\u00111OAk\u0015\u0011\tI\"!\u0016\n\t\u0005e\u00171\u001b\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018!D7fiJL7m]$s_V\u0004\b%A\u0005tQ>,H\u000e\u001a*v]V\u0011\u0011\u0011\u001d\t\u0005\u0003G\f\t0\u0004\u0002\u0002f*!\u0011q]Au\u0003\u0019\tGo\\7jG*!\u00111^Aw\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003_L\u0017\u0001B;uS2LA!a=\u0002f\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f!b\u001d5pk2$'+\u001e8!\u00031iW\r\u001e:jGB\u0013XMZ5y)\t\tY\u0010\u0005\u0003\u0002~\n-a\u0002BA\u0000\u0005\u000f\u0001BA!\u0001\u0002(5\u0011!1\u0001\u0006\u0004\u0005\u000b9\u0018A\u0002\u001fs_>$h(\u0003\u0003\u0003\n\u0005\u001d\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0003\u000e\t=!AB*ue&twM\u0003\u0003\u0003\n\u0005\u001d\u0012\u0001\u0004;ie\u0016\fG\r\u0015:fM&D\u0018AD:f]\u0012\u0014UO\u001a4feNK'0Z\u000b\u0003\u0005/\u00012A\u001aB\r\u0013\r\u0011Yb\u001a\u0002\b\u0013:$XmZ3s\u0003=\u0019XM\u001c3Ck\u001a4WM]*ju\u0016\u0004\u0013A\u0004:fGZ\u0014UO\u001a4feNK'0Z\u0001\u0010e\u0016\u001cgOQ;gM\u0016\u00148+\u001b>fA\u0005\tB.[:uK:\u0014\u0015mY6m_\u001e\u001c\u0016N_3\u0002%1L7\u000f^3o\u0005\u0006\u001c7\u000e\\8h'&TX\rI\u0001\f]&|7+\u001a7fGR|'/\u0006\u0002\u0003,A!!Q\u0006B\u001c\u001b\t\u0011yC\u0003\u0003\u00032\tM\u0012\u0001C2iC:tW\r\\:\u000b\u0007\tU\u0012.A\u0002oS>LAA!\u000f\u00030\tA1+\u001a7fGR|'/\u0001\u0007oS>\u001cV\r\\3di>\u0014\b%A\u0007tKJ4XM]\"iC:tW\r\\\u000b\u0003\u0005\u0003\u0002BA!\f\u0003D%!!Q\tB\u0018\u0005M\u0019VM\u001d<feN{7m[3u\u0007\"\fgN\\3m\u0003E\u0019XM\u001d<fe\u000eC\u0017M\u001c8fY~#S-\u001d\u000b\u0005\u0003G\u0011Y\u0005C\u0005\u00022\r\n\t\u00111\u0001\u0003B\u0005q1/\u001a:wKJ\u001c\u0005.\u00198oK2\u0004\u0013!\u00037pG\u0006d\u0007k\u001c:u+\t\t9$\u0001\u0006m_\u000e\fG\u000eU8si\u0002\n!\u0002\u001d:pG\u0016\u001c8o\u001c:t+\t\u0011I\u0006\u0005\u0004\u0003\\\t\u0015$\u0011N\u0007\u0003\u0005;RAAa\u0018\u0003b\u00059Q.\u001e;bE2,'\u0002\u0002B2\u0003O\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119G!\u0018\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004u\n-\u0014b\u0001B7A\nI\u0001K]8dKN\u001cxN]\u0001\faJ|7-Z:t_J\u001c\b%A\u000fcY>\u001c7.\u001a3QKJ\u001cWM\u001c;NKR,'/T3ue&\u001cg*Y7f+\t\u0011)\b\u0005\u0003\u0003x\t\u001dUB\u0001B=\u0015\u0011\u0011YH! \u0002\t\r|'/\u001a\u0006\u0005\u0003g\u0012yH\u0003\u0003\u0003\u0002\n\r\u0015AB=b[6,'O\u0003\u0002\u0003\u0006\u0006\u00191m\\7\n\t\t%%\u0011\u0010\u0002\u000b\u001b\u0016$(/[2OC6,\u0017A\b2m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014X*\u001a;sS\u000et\u0015-\\3!\u0003M\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3s+\t\u0011\t\n\u0005\u0003\u0003x\tM\u0015\u0002\u0002BK\u0005s\u0012Q!T3uKJ\fAC\u00197pG.,G\rU3sG\u0016tG/T3uKJ\u0004\u0013!F2veJ,g\u000e\u001e)s_\u000e,7o]8s\u0013:$W\r_\u0001\u001aGV\u0014(/\u001a8u!J|7-Z:t_JLe\u000eZ3y?\u0012*\u0017\u000f\u0006\u0003\u0002$\t}\u0005\"CA\u0019]\u0005\u0005\t\u0019AA\u001c\u0003Y\u0019WO\u001d:f]R\u0004&o\\2fgN|'/\u00138eKb\u0004\u0013\u0001\u0005;ie>$H\u000f\\3e'>\u001c7.\u001a;t+\t\u00119\u000b\u0005\u0004\u0003\\\t%&QV\u0005\u0005\u0005W\u0013iFA\u0007Qe&|'/\u001b;z#V,W/\u001a\t\u0004\u0005_KT\"\u0001\u0001\u0003%\u0011+G.Y=fI\u000ecwn]3T_\u000e\\W\r^\n\ns\tU&1\u0018Bg\u0005'\u0004B!!\n\u00038&!!\u0011XA\u0014\u0005\u0019\te.\u001f*fMB1!Q\u0018Bd\u0005[sAAa0\u0003D:!!\u0011\u0001Ba\u0013\t\tI#\u0003\u0003\u0003F\u0006\u001d\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005\u0013\u0014YMA\u0004Pe\u0012,'/\u001a3\u000b\t\t\u0015\u0017q\u0005\t\u0005\u0003K\u0011y-\u0003\u0003\u0003R\u0006\u001d\"a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003K\u0011).\u0003\u0003\u0003X\u0006\u001d\"\u0001D*fe&\fG.\u001b>bE2,\u0017AB:pG.,G/\u0006\u0002\u0003^B!!Q\u0006Bp\u0013\u0011\u0011\tOa\f\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003\u001d\u0019xnY6fi\u0002\n\u0011#\u001a8e)\"\u0014x\u000e\u001e;mKRKW.Z't+\t\u0011I\u000f\u0005\u0003\u0002&\t-\u0018\u0002\u0002Bw\u0003O\u0011A\u0001T8oO\u0006\u0011RM\u001c3UQJ|G\u000f\u001e7f)&lW-T:!)\u0019\u0011iKa=\u0003v\"9!\u0011\u001c A\u0002\tu\u0007b\u0002Bs}\u0001\u0007!\u0011^\u0001\bG>l\u0007/\u0019:f)\u0011\t9Da?\t\u000f\tux\b1\u0001\u0003.\u0006!A\u000f[1u\u0003\u0011\u0019w\u000e]=\u0015\r\t561AB\u0003\u0011%\u0011I\u000e\u0011I\u0001\u0002\u0004\u0011i\u000eC\u0005\u0003f\u0002\u0003\n\u00111\u0001\u0003j\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB\u0006U\u0011\u0011in!\u0004,\u0005\r=\u0001\u0003BB\t\u00077i!aa\u0005\u000b\t\rU1qC\u0001\nk:\u001c\u0007.Z2lK\u0012TAa!\u0007\u0002(\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\ru11\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0007GQCA!;\u0004\u000e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"a!\u000b\u0011\u0007\u0019\u001cY#C\u0002\u0003\u000e\u001d\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00044\re\u0002\u0003BA\u0013\u0007kIAaa\u000e\u0002(\t\u0019\u0011I\\=\t\u0013\u0005ER)!AA\u0002\u0005]\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r}\u0002CBB!\u0007\u0007\u001a\u0019$\u0004\u0002\u0003b%!1Q\tB1\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001541\n\u0005\n\u0003c9\u0015\u0011!a\u0001\u0007g\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003o\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007S\ta!Z9vC2\u001cH\u0003BA3\u00073B\u0011\"!\rK\u0003\u0003\u0005\raa\r\u0002#QD'o\u001c;uY\u0016$7k\\2lKR\u001c\b%A\u0004ti\u0006\u0014H/\u001a3\u0002\u0011M$\u0018M\u001d;fI\u0002\nQb\u001d;beR,GMR;ukJ,WCAB3!\u0019\u00199g!\u001b\u0004n5\u0011\u0011\u0011^\u0005\u0005\u0007W\nIOA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u00042AZB8\u0013\r\u0019\th\u001a\u0002\u0005->LG-\u0001\bti\u0006\u0014H/\u001a3GkR,(/\u001a\u0011\u0002\rQD'/Z1e+\t\u0019I\b\u0005\u0003\u0002N\rm\u0014\u0002BB?\u0003\u001f\u00121bS1gW\u0006$\u0006N]3bI\u00069A\u000f\u001b:fC\u0012\u0004\u0013!B:uCJ$HCAA\u0012\u0003I!U\r\\1zK\u0012\u001cEn\\:f'>\u001c7.\u001a;\u0011\u0007\t=FjE\u0003M\u0007\u0017\u0013\u0019\u000e\u0005\u0006\u0004\u000e\u000eM%Q\u001cBu\u0005[k!aa$\u000b\t\rE\u0015qE\u0001\beVtG/[7f\u0013\u0011\u0019)ja$\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0004\b\u0006)\u0011\r\u001d9msR1!QVBO\u0007?CqA!7P\u0001\u0004\u0011i\u000eC\u0004\u0003f>\u0003\rA!;\u0002\u000fUt\u0017\r\u001d9msR!1QUBY!\u0019\t)ca*\u0004,&!1\u0011VA\u0014\u0005\u0019y\u0005\u000f^5p]BA\u0011QEBW\u0005;\u0014I/\u0003\u0003\u00040\u0006\u001d\"A\u0002+va2,'\u0007C\u0005\u00044B\u000b\t\u00111\u0001\u0003.\u0006\u0019\u0001\u0010\n\u0019\u0002!I,Wn\u001c<f!J|7-Z:t_J\u001cH\u0003BA\u0012\u0007sCqaa/R\u0001\u0004\t9$A\u0006sK6|g/Z\"pk:$\u0018!\u00042fO&t7\u000b[;uI><h.A\u0003dY>\u001cX-A\u0002sk:\f\u0001b\u00197pg\u0016\fE\u000e\\\u0001\u0011_B,gnU3sm\u0016\u00148k\\2lKR$\u0002B!\u0011\u0004J\u000e57\u0011\u001b\u0005\b\u0007\u00174\u0006\u0019AA~\u0003\u0011Awn\u001d;\t\u000f\r=g\u000b1\u0001\u00028\u0005!\u0001o\u001c:u\u0011\u001d\u0011\u0019C\u0016a\u0001\u0003o\tA#Y2dKB$h*Z<D_:tWm\u0019;j_:\u001c\u0018AB1dG\u0016\u0004H\u000f\u0006\u0003\u0004Z\u000em\u0007CBA\u0013\u0007O\u0013i\u000eC\u0004\u0004^b\u0003\raa8\u0002\u0007-,\u0017\u0010\u0005\u0003\u0003.\r\u0005\u0018\u0002BBr\u0005_\u0011AbU3mK\u000e$\u0018n\u001c8LKf\fadY8oM&<WO]3BG\u000e,\u0007\u000f^3e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0015\t\u0005\r2\u0011\u001e\u0005\b\u0007WL\u0006\u0019\u0001Bo\u00035\u0019xnY6fi\u000eC\u0017M\u001c8fY\u0006I2\r\\8tKRC'o\u001c;uY\u0016$7i\u001c8oK\u000e$\u0018n\u001c8t\u0003M\t7o]5h]:+woQ8o]\u0016\u001cG/[8o)!\t)ga=\u0004v\u000ee\bbBBv7\u0002\u0007!Q\u001c\u0005\b\u0007o\\\u0006\u0019\u0001B5\u0003%\u0001(o\\2fgN|'\u000fC\u0004\u0004|n\u0003\r!!\u001a\u0002\u00115\f\u0017P\u00117pG.\faa^1lKV\u0004\u0018!D1eIB\u0013xnY3tg>\u00148\u000f\u0006\u0003\u0002$\u0011\r\u0001b\u0002C\u0003;\u0002\u0007\u0011qG\u0001\ti>\u001c%/Z1uK\u0006aa.Z<Qe>\u001cWm]:peRA!\u0011\u000eC\u0006\t\u001f!i\u0002C\u0004\u0005\u000ey\u0003\r!a\u000e\u0002\u0005%$\u0007b\u0002C\t=\u0002\u0007A1C\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\t+!I\"\u0004\u0002\u0005\u0018)\u0019\u0011-!\u0015\n\t\u0011mAq\u0003\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\t?q\u0006\u0019\u0001C\u0011\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0003\u0005$\u0011-RB\u0001C\u0013\u0015\u0011!9\u0003\"\u000b\u0002\t\u0005,H\u000f\u001b\u0006\u0005\u0003\u000f\u000b\t&\u0003\u0003\u0005.\u0011\u0015\"\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0001")
public abstract class Acceptor
implements Runnable,
Logging {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final SocketServer socketServer;
    private final EndPoint endPoint;
    private KafkaConfig config;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final boolean isPrivilegedListener;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final LogContext logContext;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicBoolean shouldRun;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;
    private final Integer listenBacklogSize;
    private final Selector nioSelector;
    private ServerSocketChannel serverChannel;
    private final int localPort;
    private final ArrayBuffer<Processor> processors;
    private final MetricName blockedPercentMeterMetricName;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private final AtomicBoolean started;
    private final CompletableFuture<Void> startedFuture;
    private final KafkaThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicBoolean shouldRun() {
        return this.shouldRun;
    }

    public abstract String metricPrefix();

    public abstract String threadPrefix();

    private Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    private Integer recvBufferSize() {
        return this.recvBufferSize;
    }

    private Integer listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    public void serverChannel_$eq(ServerSocketChannel x$1) {
        this.serverChannel = x$1;
    }

    public int localPort() {
        return this.localPort;
    }

    public ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private MetricName blockedPercentMeterMetricName() {
        return this.blockedPercentMeterMetricName;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    public CompletableFuture<Void> startedFuture() {
        return this.startedFuture;
    }

    public KafkaThread thread() {
        return this.thread;
    }

    public void start() {
        synchronized (this) {
            this.liftedTree1$1();
            return;
        }
    }

    public synchronized void removeProcessors(int removeCount) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            this.requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    public void beginShutdown() {
        if (this.shouldRun().getAndSet(false)) {
            this.wakeup();
            synchronized (this) {
                this.processors().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
                    x$15.beginShutdown();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public void close() {
        this.beginShutdown();
        this.thread().join();
        if (!this.started().get()) {
            this.closeAll();
        }
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                x$16.close();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        try {
            while (this.shouldRun().get()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ControlThrowable) {
                        throw (Throwable)((ControlThrowable)throwable);
                    }
                    if (throwable == null) throw null;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    continue;
                    return;
                }
            }
        }
        finally {
            this.closeAll();
        }
    }

    private void closeAll() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
        this.throttledSockets().foreach((Function1 & Serializable & scala.Serializable)throttledSocket -> {
            SocketServer$.MODULE$.closeSocket(throttledSocket.socket(), this);
            return BoxedUnit.UNIT;
        });
        this.throttledSockets().clear();
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        try {
            serverChannel.configureBlocking(false);
            if (!BoxesRunTime.equalsNumObject((Number)this.recvBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
                serverChannel.socket().setReceiveBufferSize(Predef$.MODULE$.Integer2int(this.recvBufferSize()));
            }
            serverChannel.socket().bind(socketAddress, listenBacklogSize);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            Utils.closeQuietly((AutoCloseable)serverChannel, (String)"server socket");
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.shouldRun().get()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable & scala.Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            return;
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas().inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            this.configureAcceptedSocketChannel(socketChannel);
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
        catch (IOException e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered an error while configuring the connection, closing it.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    public void configureAcceptedSocketChannel(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        if (!BoxesRunTime.equalsNumObject((Number)this.sendBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            socketChannel.socket().setSendBufferSize(Predef$.MODULE$.Integer2int(this.sendBufferSize()));
            return;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$17)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            SocketServer$.MODULE$.closeSocket(closingSocket.socket(), this);
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public void addProcessors(int toCreate) {
        synchronized (this) {
            ListenerName listenerName = this.endPoint().listenerName();
            SecurityProtocol securityProtocol = this.endPoint().securityProtocol();
            ArrayBuffer listenerProcessors = new ArrayBuffer();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), toCreate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Processor processor = this.newProcessor(this.socketServer().nextProcessorId(), listenerName, securityProtocol);
                listenerProcessors.$plus$eq((Object)processor);
                $this.requestChannel.addProcessor(processor);
                if (this.started().get()) {
                    processor.start();
                    return;
                }
            });
            this.processors().$plus$plus$eq((TraversableOnce)listenerProcessors);
            return;
        }
    }

    public Processor newProcessor(int id, ListenerName listenerName, SecurityProtocol securityProtocol) {
        String name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-network-thread-").append(this.nodeId).append("-").append(this.endPoint().listenerName()).append("-").append(this.endPoint().securityProtocol()).append("-").append(id).toString();
        return new Processor(id, this.time, Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel, this.connectionQuotas(), Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics, this.credentialProvider, this.memoryPool, this.logContext, Processor$.MODULE$.ConnectionQueueSize(), this.isPrivilegedListener, this.apiVersionManager, name);
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    private final /* synthetic */ Object liftedTree1$1() {
        try {
            if (!this.shouldRun().get()) {
                throw new ClosedChannelException();
            }
            if (this.serverChannel() == null) {
                this.serverChannel_$eq(this.openServerSocket(this.endPoint().host(), this.endPoint().port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Opened endpoint ").append(this.endPoint().host()).append(":").append(this.endPoint().port()).toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Starting processors for listener ").append(this.endPoint().listenerName()).toString());
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                x$13.start();
                return BoxedUnit.UNIT;
            });
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Starting acceptor thread for listener ").append(this.endPoint().listenerName()).toString());
            this.thread().start();
            this.startedFuture().complete(null);
            this.started().set(true);
            return BoxedUnit.UNIT;
        }
        catch (ClosedChannelException e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Refusing to start acceptor for ").append(this.endPoint().listenerName()).append(" since the acceptor has already been shut down.").toString());
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(e));
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Unable to start acceptor for ").append(this.endPoint().listenerName()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(new RuntimeException(new StringBuilder(29).append("Unable to start acceptor for ").append(this.endPoint().listenerName()).toString(), t)));
        }
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$17) {
        return x$17.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(SocketServer socketServer, EndPoint endPoint, KafkaConfig config, int nodeId, ConnectionQuotas connectionQuotas, Time time, boolean isPrivilegedListener, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager) {
        int n;
        this.socketServer = socketServer;
        this.endPoint = endPoint;
        this.config = config;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        this.isPrivilegedListener = isPrivilegedListener;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.logContext = logContext;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.shouldRun = new AtomicBoolean(true);
        this.sendBufferSize = this.config().socketSendBufferBytes();
        this.recvBufferSize = this.config().socketReceiveBufferBytes();
        this.listenBacklogSize = this.config().socketListenBacklogSize();
        this.nioSelector = Selector.open();
        if (endPoint.port() != 0) {
            n = endPoint.port();
        } else {
            this.serverChannel_$eq(this.openServerSocket(endPoint.host(), endPoint.port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
            int newPort = this.serverChannel().socket().getLocalPort();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Opened wildcard endpoint ").append(this.endPoint().host()).append(":").append(newPort).toString());
            n = newPort;
        }
        this.localPort = n;
        this.processors = new ArrayBuffer();
        this.blockedPercentMeterMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.network", (String)"Acceptor", (String)new StringBuilder(22).append(this.metricPrefix()).append("AcceptorBlockedPercent").toString(), (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))).asJava()));
        this.blockedPercentMeter = this.metricsGroup().newMeter(this.blockedPercentMeterMetricName(), "blocked time", TimeUnit.NANOSECONDS);
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        this.started = new AtomicBoolean();
        this.startedFuture = new CompletableFuture();
        String nonDaemon_name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-socket-acceptor-").append(endPoint.listenerName()).append("-").append(endPoint.securityProtocol()).append("-").append(endPoint.port()).toString();
        this.thread = new KafkaThread(nonDaemon_name, (Runnable)this, false);
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    scala.Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof DelayedCloseSocket && ((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() == this.kafka$network$Acceptor$DelayedCloseSocket$$$outer())) break block3;
                    DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
                    SocketChannel socketChannel = this.socket();
                    SocketChannel socketChannel2 = delayedCloseSocket.socket();
                    if (socketChannel != null ? !socketChannel.equals(socketChannel2) : socketChannel2 != null) break block3;
                    if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs() || !delayedCloseSocket.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

