/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.classic;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum ClassicGroupState {
    EMPTY("Empty"),
    PREPARING_REBALANCE("PreparingRebalance"),
    COMPLETING_REBALANCE("CompletingRebalance"),
    STABLE("Stable"),
    DEAD("Dead");

    private final String name;
    private Set<ClassicGroupState> validPreviousStates;

    private ClassicGroupState(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    private void addValidPreviousStates(ClassicGroupState ... validPreviousStates) {
        this.validPreviousStates = new HashSet<ClassicGroupState>(Arrays.asList(validPreviousStates));
    }

    public Set<ClassicGroupState> validPreviousStates() {
        return this.validPreviousStates;
    }

    static {
        EMPTY.addValidPreviousStates(PREPARING_REBALANCE);
        PREPARING_REBALANCE.addValidPreviousStates(STABLE, COMPLETING_REBALANCE, EMPTY);
        COMPLETING_REBALANCE.addValidPreviousStates(PREPARING_REBALANCE);
        STABLE.addValidPreviousStates(COMPLETING_REBALANCE);
        DEAD.addValidPreviousStates(STABLE, PREPARING_REBALANCE, COMPLETING_REBALANCE, EMPTY, DEAD);
    }
}

