/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.serialization;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataRecord;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogMetadataTransform;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;

public class RemoteLogSegmentMetadataTransform
implements RemoteLogMetadataTransform<RemoteLogSegmentMetadata> {
    @Override
    public ApiMessageAndVersion toApiMessageAndVersion(RemoteLogSegmentMetadata segmentMetadata) {
        RemoteLogSegmentMetadataRecord record = new RemoteLogSegmentMetadataRecord().setRemoteLogSegmentId(this.createRemoteLogSegmentIdEntry(segmentMetadata)).setStartOffset(segmentMetadata.startOffset()).setEndOffset(segmentMetadata.endOffset()).setBrokerId(segmentMetadata.brokerId()).setEventTimestampMs(segmentMetadata.eventTimestampMs()).setMaxTimestampMs(segmentMetadata.maxTimestampMs()).setSegmentSizeInBytes(segmentMetadata.segmentSizeInBytes()).setSegmentLeaderEpochs(this.createSegmentLeaderEpochsEntry(segmentMetadata)).setRemoteLogSegmentState(segmentMetadata.state().id());
        segmentMetadata.customMetadata().ifPresent(md -> record.setCustomMetadata(md.value()));
        return new ApiMessageAndVersion((ApiMessage)record, record.highestSupportedVersion());
    }

    private List<RemoteLogSegmentMetadataRecord.SegmentLeaderEpochEntry> createSegmentLeaderEpochsEntry(RemoteLogSegmentMetadata data) {
        return data.segmentLeaderEpochs().entrySet().stream().map(entry -> new RemoteLogSegmentMetadataRecord.SegmentLeaderEpochEntry().setLeaderEpoch((Integer)entry.getKey()).setOffset((Long)entry.getValue())).collect(Collectors.toList());
    }

    private RemoteLogSegmentMetadataRecord.RemoteLogSegmentIdEntry createRemoteLogSegmentIdEntry(RemoteLogSegmentMetadata data) {
        return new RemoteLogSegmentMetadataRecord.RemoteLogSegmentIdEntry().setTopicIdPartition(new RemoteLogSegmentMetadataRecord.TopicIdPartitionEntry().setId(data.remoteLogSegmentId().topicIdPartition().topicId()).setName(data.remoteLogSegmentId().topicIdPartition().topic()).setPartition(data.remoteLogSegmentId().topicIdPartition().partition())).setId(data.remoteLogSegmentId().id());
    }

    @Override
    public RemoteLogSegmentMetadata fromApiMessageAndVersion(ApiMessageAndVersion apiMessageAndVersion) {
        RemoteLogSegmentMetadataRecord record = (RemoteLogSegmentMetadataRecord)apiMessageAndVersion.message();
        RemoteLogSegmentId remoteLogSegmentId = this.buildRemoteLogSegmentId(record.remoteLogSegmentId());
        HashMap<Integer, Long> segmentLeaderEpochs = new HashMap<Integer, Long>();
        for (RemoteLogSegmentMetadataRecord.SegmentLeaderEpochEntry segmentLeaderEpoch : record.segmentLeaderEpochs()) {
            segmentLeaderEpochs.put(segmentLeaderEpoch.leaderEpoch(), segmentLeaderEpoch.offset());
        }
        Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata = Optional.ofNullable(record.customMetadata()).map(RemoteLogSegmentMetadata.CustomMetadata::new);
        RemoteLogSegmentMetadata remoteLogSegmentMetadata = new RemoteLogSegmentMetadata(remoteLogSegmentId, record.startOffset(), record.endOffset(), record.maxTimestampMs(), record.brokerId(), record.eventTimestampMs(), record.segmentSizeInBytes(), segmentLeaderEpochs);
        RemoteLogSegmentMetadataUpdate rlsmUpdate = new RemoteLogSegmentMetadataUpdate(remoteLogSegmentId, record.eventTimestampMs(), customMetadata, RemoteLogSegmentState.forId((byte)record.remoteLogSegmentState()), record.brokerId());
        return remoteLogSegmentMetadata.createWithUpdates(rlsmUpdate);
    }

    private RemoteLogSegmentId buildRemoteLogSegmentId(RemoteLogSegmentMetadataRecord.RemoteLogSegmentIdEntry entry) {
        TopicIdPartition topicIdPartition = new TopicIdPartition(entry.topicIdPartition().id(), new TopicPartition(entry.topicIdPartition().name(), entry.topicIdPartition().partition()));
        return new RemoteLogSegmentId(topicIdPartition, entry.id());
    }
}

