/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.resolver;

import org.apache.fory.collection.Tuple2;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.meta.Encoders;
import org.apache.fory.meta.MetaString;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.MetaStringBytes;
import org.apache.fory.resolver.MetaStringResolver;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.function.Functions;

public class ClassInfo {
    final Class<?> cls;
    final MetaStringBytes fullNameBytes;
    final MetaStringBytes namespaceBytes;
    final MetaStringBytes typeNameBytes;
    final boolean isDynamicGeneratedClass;
    int xtypeId;
    Serializer<?> serializer;
    short classId;
    ClassDef classDef;
    boolean needToWriteClassDef;

    ClassInfo(Class<?> cls, MetaStringBytes fullNameBytes, MetaStringBytes namespaceBytes, MetaStringBytes typeNameBytes, boolean isDynamicGeneratedClass, Serializer<?> serializer, short classId, short xtypeId) {
        this.cls = cls;
        this.fullNameBytes = fullNameBytes;
        this.namespaceBytes = namespaceBytes;
        this.typeNameBytes = typeNameBytes;
        this.isDynamicGeneratedClass = isDynamicGeneratedClass;
        this.xtypeId = xtypeId;
        this.serializer = serializer;
        this.classId = classId;
        if (cls != null && classId == 0) {
            Preconditions.checkArgument(typeNameBytes != null);
        }
    }

    ClassInfo(ClassResolver classResolver, Class<?> cls, Serializer<?> serializer, short classId, short xtypeId) {
        this.cls = cls;
        this.serializer = serializer;
        this.needToWriteClassDef = serializer != null && classResolver.needToWriteClassDef(serializer);
        MetaStringResolver metaStringResolver = classResolver.getMetaStringResolver();
        this.fullNameBytes = cls != null && classResolver.getFory().isCrossLanguage() ? metaStringResolver.getOrCreateMetaStringBytes(Encoders.GENERIC_ENCODER.encode(cls.getName(), MetaString.Encoding.UTF_8)) : null;
        if (cls != null && (classId == 0 || classId == 3)) {
            Tuple2<String, String> tuple2 = Encoders.encodePkgAndClass(cls);
            this.namespaceBytes = metaStringResolver.getOrCreateMetaStringBytes(Encoders.encodePackage((String)tuple2.f0));
            this.typeNameBytes = metaStringResolver.getOrCreateMetaStringBytes(Encoders.encodeTypeName((String)tuple2.f1));
        } else {
            this.namespaceBytes = null;
            this.typeNameBytes = null;
        }
        this.xtypeId = xtypeId;
        this.classId = classId;
        if (cls != null) {
            boolean isLambda = Functions.isLambda(cls);
            boolean isProxy = classId != 3 && ReflectionUtils.isJdkProxy(cls);
            boolean bl = this.isDynamicGeneratedClass = isLambda || isProxy;
            if (isLambda) {
                this.classId = 1;
            }
            if (isProxy) {
                this.classId = (short)2;
            }
        } else {
            this.isDynamicGeneratedClass = false;
        }
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public short getClassId() {
        return this.classId;
    }

    public int getXtypeId() {
        return this.xtypeId;
    }

    public <T> Serializer<T> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer<?> serializer) {
        this.serializer = serializer;
    }

    void setSerializer(ClassResolver resolver, Serializer<?> serializer) {
        this.serializer = serializer;
        this.needToWriteClassDef = serializer != null && resolver.needToWriteClassDef(serializer);
    }

    public String decodeNamespace() {
        return this.namespaceBytes.decode(Encoders.PACKAGE_DECODER);
    }

    public String decodeTypeName() {
        return this.typeNameBytes.decode(Encoders.TYPE_NAME_DECODER);
    }

    public String toString() {
        return "ClassInfo{cls=" + this.cls + ", fullClassNameBytes=" + this.fullNameBytes + ", isDynamicGeneratedClass=" + this.isDynamicGeneratedClass + ", serializer=" + this.serializer + ", classId=" + this.classId + '}';
    }
}

