/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadFactories {
    private static final ThreadFactory BACKING_FACTORY = Executors.defaultThreadFactory();

    private ThreadFactories() {
    }

    public static ThreadFactory withName(final String fmt) {
        return new ThreadFactory(){
            private final AtomicLong count = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = BACKING_FACTORY.newThread(r);
                t.setDaemon(true);
                t.setName(String.format(fmt, this.count.getAndIncrement()));
                return t;
            }
        };
    }
}

