/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.metrics.registry.compact;

import java.util.Collections;
import java.util.function.Supplier;
import org.apache.seata.metrics.Clock;
import org.apache.seata.metrics.Gauge;
import org.apache.seata.metrics.Id;
import org.apache.seata.metrics.Measurement;
import org.apache.seata.metrics.SystemClock;

public class CompactGauge<T extends Number>
implements Gauge<T> {
    private final Id id;
    private final Supplier<T> supplier;
    private final Clock clock;

    public CompactGauge(Id id, Supplier<T> supplier) {
        this(id, supplier, SystemClock.INSTANCE);
    }

    public CompactGauge(Id id, Supplier<T> supplier, Clock clock) {
        this.id = id;
        this.supplier = supplier;
        this.clock = clock;
    }

    public T get() {
        return (T)((Number)this.supplier.get());
    }

    public Id getId() {
        return this.id;
    }

    public Iterable<Measurement> measure() {
        return Collections.singletonList(new Measurement(this.id, this.clock.getCurrentMilliseconds(), ((Number)this.get()).doubleValue()));
    }
}

