/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.ozhera.log.manager.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ozhera.log.manager.model.dto.DashboardGraphDTO;
import org.apache.ozhera.log.manager.model.dto.GraphDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogAnalyseGraphDO;
import org.apache.ozhera.log.manager.model.vo.GraphQuery;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * Mapper
 * </p>
 *
 * @author wanghaoyang
 * @since 2022-08-18
 */
@Mapper
public interface MilogAnalyseGraphMapper extends BaseMapper<MilogAnalyseGraphDO> {

    List<DashboardGraphDTO> getDashboardGraph(@Param(value = "dashboardId") Long dashboardId);

    List<GraphDTO> search(@Param(value = "query") GraphQuery query);
}
