/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import java.lang.reflect.Array;
import java.util.List;
import org.simpleflatmapper.map.context.KeyAndPredicate;
import org.simpleflatmapper.map.context.KeyDefinition;
import org.simpleflatmapper.map.context.KeySourceGetter;

public class KeyDefinitionBuilder<S, K> {
    private final KeySourceGetter<K, ? super S> keySourceGetter;
    private final List<KeyAndPredicate<S, K>> keyAndPredicates;
    private final int index;

    public KeyDefinitionBuilder(List<KeyAndPredicate<S, K>> keyAndPredicates, KeySourceGetter<K, ? super S> keySourceGetter, int index) {
        this.keyAndPredicates = keyAndPredicates;
        this.keySourceGetter = keySourceGetter;
        this.index = index;
    }

    public KeyDefinitionBuilder<S, K> asChild(int currentIndex) {
        return new KeyDefinitionBuilder<S, K>(this.keyAndPredicates, this.keySourceGetter, currentIndex);
    }

    public static <S, K> KeyDefinition<S, K>[] toKeyDefinitions(KeyDefinitionBuilder<S, K>[] siblings) {
        KeyDefinition[] keyDefinitions = new KeyDefinition[siblings.length];
        for (KeyDefinitionBuilder<S, K> builder : siblings) {
            KeyDefinition<? super S, K> keyDefinition;
            keyDefinitions[builder.index] = keyDefinition = new KeyDefinition<S, K>(KeyDefinitionBuilder.toArray(builder.keyAndPredicates), builder.keySourceGetter, builder.index);
        }
        return keyDefinitions;
    }

    private static <K> K[] toArray(List<K> keys) {
        if (keys.size() == 0) {
            return null;
        }
        return keys.toArray((Object[])Array.newInstance(keys.get(0).getClass(), 0));
    }

    public List<KeyAndPredicate<S, K>> getKeyAndPredicates() {
        return this.keyAndPredicates;
    }
}

