/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.context.Key;
import org.simpleflatmapper.map.context.KeyDefinition;
import org.simpleflatmapper.map.context.impl.KeyObjectStore;

public class BreakDetector<S> {
    private final KeyDefinition<S, ?> definition;
    private final KeyObjectStore cache;
    private Key currentKey;

    public BreakDetector(KeyDefinition<S, ?> definition) {
        this.definition = BreakDetector.emptyToNull(definition);
        this.cache = this.definition == null ? null : new KeyObjectStore();
    }

    private static <S> KeyDefinition<S, ?> emptyToNull(KeyDefinition<S, ?> definition) {
        if (definition == null || definition.isEmpty()) {
            return null;
        }
        return definition;
    }

    public boolean broke(S source) throws MappingException {
        if (this.definition == null) {
            return true;
        }
        Key oldKey = this.currentKey;
        this.currentKey = this.definition.getValues(source);
        return oldKey == null || !oldKey.equals(this.currentKey);
    }

    public Key getKey(S source) {
        return this.definition.getValues(source);
    }

    public Key getCurrentKey() {
        return this.currentKey;
    }

    public void handleSource(S source) throws MappingException {
        if (this.definition == null) {
            return;
        }
        this.currentKey = this.definition.getValues(source);
    }

    public void setValue(Object value) {
        if (this.definition != null) {
            this.setValue(value, this.currentKey);
        }
    }

    public void setValue(Object value, Key key) {
        if (key == null) {
            throw new IllegalStateException("Invalid state currentKey is null");
        }
        if (key != KeyDefinition.NOT_EQUALS) {
            this.cache.put(key, value);
        }
    }

    public Object getValue() {
        if (this.definition != null) {
            return this.getValue(this.currentKey);
        }
        return null;
    }

    public Object getValue(Key key) {
        if (key == null) {
            throw new IllegalStateException("Invalid state currentKey is null");
        }
        if (key == KeyDefinition.NOT_EQUALS) {
            return null;
        }
        return this.cache.get(key);
    }

    public void markRootAsBroken() {
        if (this.definition != null) {
            this.currentKey = null;
            this.cache.clear();
        }
    }

    public boolean hasKeyDefinition() {
        return this.definition != null;
    }
}

