/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.worker.load;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.properties.Properties;
import org.apache.hugegraph.computer.core.graph.vertex.DefaultVertex;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.input.EdgeFetcher;
import org.apache.hugegraph.computer.core.input.GraphFetcher;
import org.apache.hugegraph.computer.core.input.HugeConverter;
import org.apache.hugegraph.computer.core.input.InputFilter;
import org.apache.hugegraph.computer.core.input.InputSourceFactory;
import org.apache.hugegraph.computer.core.input.InputSplit;
import org.apache.hugegraph.computer.core.input.VertexFetcher;
import org.apache.hugegraph.computer.core.rpc.InputSplitRpcService;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;

public class LoadService {
    private final GraphFactory graphFactory;
    private final Config config;
    private GraphFetcher fetcher;
    private InputSplitRpcService rpcService;
    private final InputFilter inputFilter;

    public LoadService(ComputerContext context) {
        this.graphFactory = context.graphFactory();
        this.config = context.config();
        this.fetcher = null;
        this.rpcService = null;
        this.inputFilter = (InputFilter)context.config().createObject(ComputerOptions.INPUT_FILTER_CLASS);
    }

    public void init() {
        assert (this.rpcService != null);
        this.fetcher = InputSourceFactory.createGraphFetcher(this.config, this.rpcService);
    }

    public void close() {
        this.fetcher.close();
    }

    public void rpcService(InputSplitRpcService rpcService) {
        E.checkNotNull((Object)rpcService, (String)"rpcService");
        this.rpcService = rpcService;
    }

    public Iterator<Vertex> createIteratorFromVertex() {
        return new IteratorFromVertex();
    }

    public Iterator<Vertex> createIteratorFromEdge() {
        return new IteratorFromEdge();
    }

    private class IteratorFromEdge
    implements Iterator<Vertex> {
        private final int maxEdges;
        private InputSplit currentSplit;
        private Vertex currentVertex;

        public IteratorFromEdge() {
            this.maxEdges = (Integer)LoadService.this.config.get((TypedOption)ComputerOptions.INPUT_MAX_EDGES_IN_ONE_VERTEX);
            this.currentSplit = null;
            this.currentVertex = null;
        }

        @Override
        public boolean hasNext() {
            if (InputSplit.END_SPLIT.equals(this.currentSplit)) {
                return this.currentVertex != null;
            }
            EdgeFetcher edgeFetcher = LoadService.this.fetcher.edgeFetcher();
            while (this.currentSplit == null || !edgeFetcher.hasNext()) {
                this.currentSplit = LoadService.this.fetcher.nextEdgeInputSplit();
                if (this.currentSplit.equals(InputSplit.END_SPLIT)) {
                    return this.currentVertex != null;
                }
                edgeFetcher.prepareLoadInputSplit(this.currentSplit);
            }
            return true;
        }

        @Override
        public Vertex next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EdgeFetcher edgeFetcher = LoadService.this.fetcher.edgeFetcher();
            while (edgeFetcher.hasNext()) {
                org.apache.hugegraph.structure.graph.Edge hugeEdge = (org.apache.hugegraph.structure.graph.Edge)edgeFetcher.next();
                Edge edge = this.convert(hugeEdge);
                Id sourceId = HugeConverter.convertId(hugeEdge.sourceId());
                if (this.currentVertex == null) {
                    this.currentVertex = new DefaultVertex(LoadService.this.graphFactory, sourceId, null);
                    this.currentVertex.addEdge(edge);
                    continue;
                }
                if (this.currentVertex.id().equals(sourceId) && this.currentVertex.numEdges() < this.maxEdges) {
                    this.currentVertex.addEdge(edge);
                    continue;
                }
                Vertex vertex = this.currentVertex;
                this.currentVertex = new DefaultVertex(LoadService.this.graphFactory, sourceId, null);
                this.currentVertex.addEdge(edge);
                return vertex;
            }
            assert (this.currentVertex != null);
            Vertex vertex = this.currentVertex;
            this.currentVertex = null;
            return vertex;
        }

        private Edge convert(org.apache.hugegraph.structure.graph.Edge edge) {
            edge = LoadService.this.inputFilter.filter(edge);
            Id targetId = HugeConverter.convertId(edge.targetId());
            Properties properties = HugeConverter.convertProperties(edge.properties());
            Edge computerEdge = LoadService.this.graphFactory.createEdge(edge.label(), edge.name(), targetId);
            computerEdge.label(edge.label());
            computerEdge.properties(properties);
            return computerEdge;
        }
    }

    private class IteratorFromVertex
    implements Iterator<Vertex> {
        private InputSplit currentSplit = null;

        @Override
        public boolean hasNext() {
            VertexFetcher vertexFetcher = LoadService.this.fetcher.vertexFetcher();
            while (this.currentSplit == null || !vertexFetcher.hasNext()) {
                this.currentSplit = LoadService.this.fetcher.nextVertexInputSplit();
                if (this.currentSplit.equals(InputSplit.END_SPLIT)) {
                    return false;
                }
                vertexFetcher.prepareLoadInputSplit(this.currentSplit);
            }
            return true;
        }

        @Override
        public Vertex next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            org.apache.hugegraph.structure.graph.Vertex hugeVertex = (org.apache.hugegraph.structure.graph.Vertex)LoadService.this.fetcher.vertexFetcher().next();
            return this.convert(hugeVertex);
        }

        private Vertex convert(org.apache.hugegraph.structure.graph.Vertex vertex) {
            vertex = LoadService.this.inputFilter.filter(vertex);
            Id id = HugeConverter.convertId(vertex.id());
            String label = vertex.label();
            Properties properties = HugeConverter.convertProperties(vertex.properties());
            Vertex computerVertex = LoadService.this.graphFactory.createVertex(label, id, null);
            computerVertex.properties(properties);
            return computerVertex;
        }
    }
}

