/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.seqfile;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.io.AbstractBufferedFileOutput;
import org.apache.hugegraph.computer.core.store.file.seqfile.ValueFile;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;

public class ValueFileOutput
extends AbstractBufferedFileOutput {
    private final long maxSegmentSize;
    private final File dir;
    private final List<File> segments;
    private int segmentIndex;
    private RandomAccessFile currentSegment;

    public ValueFileOutput(Config config, File dir) throws IOException {
        this(config, dir, 8192);
    }

    public ValueFileOutput(Config config, File dir, int bufferCapacity) throws IOException {
        super(bufferCapacity);
        this.maxSegmentSize = (Long)config.get((TypedOption)ComputerOptions.VALUE_FILE_MAX_SEGMENT_SIZE);
        E.checkArgument((this.maxSegmentSize <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Max size of segment must be smaller than '%s' but get '%s'", (Object[])new Object[]{Integer.MAX_VALUE, this.maxSegmentSize});
        E.checkArgument((bufferCapacity >= 8 && (long)bufferCapacity <= this.maxSegmentSize ? 1 : 0) != 0, (String)"The parameter bufferCapacity must be >= 8 and <= %s", (Object[])new Object[]{this.maxSegmentSize});
        E.checkArgument((boolean)dir.isDirectory(), (String)"The parameter dir must be a directory", (Object[])new Object[0]);
        this.dir = dir;
        this.segments = ValueFile.scanSegment(dir);
        this.segmentIndex = -1;
        this.currentSegment = this.nextSegment();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bufferAvailable() >= len) {
            super.write(b, off, len);
            return;
        }
        this.flushBuffer();
        if (this.bufferCapacity() >= len) {
            super.write(b, off, len);
            return;
        }
        int remain = this.currentSegmentRemain();
        if (remain >= len) {
            this.currentSegment.write(b, off, len);
        } else {
            int tempLen = len;
            int offset = off;
            this.currentSegment.write(b, offset, remain);
            tempLen -= remain;
            offset += remain;
            while (true) {
                this.currentSegment.close();
                this.currentSegment = this.nextSegment();
                if ((long)tempLen <= this.maxSegmentSize) break;
                this.currentSegment.write(b, offset, (int)this.maxSegmentSize);
                tempLen = (int)((long)tempLen - this.maxSegmentSize);
                offset = (int)((long)offset + this.maxSegmentSize);
            }
            this.currentSegment.write(b, offset, tempLen);
        }
        this.fileOffset += (long)len;
    }

    @Override
    public void seek(long position) throws IOException {
        E.checkArgument((position >= 0L ? 1 : 0) != 0, (String)"Parameter position must >= 0, but get '%s'", (Object[])new Object[]{position});
        if (this.fileOffset <= position && position <= this.position()) {
            super.seek(position - this.fileOffset);
            return;
        }
        int segmentIndex = (int)(position / this.maxSegmentSize);
        if (segmentIndex >= this.segments.size()) {
            throw new EOFException(String.format("Can't seek to %s, reach the end of file", position));
        }
        this.flushBuffer();
        if (segmentIndex != this.segmentIndex) {
            this.currentSegment.close();
            this.currentSegment = new RandomAccessFile(this.segments.get(segmentIndex), "rw");
            this.segmentIndex = segmentIndex;
        }
        long seekPosition = position - (long)segmentIndex * this.maxSegmentSize;
        this.currentSegment.seek(seekPosition);
        this.fileOffset = position;
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.currentSegment.close();
    }

    @Override
    public void flushBuffer() throws IOException {
        int bufferSize;
        int segmentRemain = this.currentSegmentRemain();
        if (segmentRemain >= (bufferSize = super.bufferSize())) {
            this.currentSegment.write(super.buffer(), 0, bufferSize);
        } else {
            this.currentSegment.write(super.buffer(), 0, segmentRemain);
            this.currentSegment.close();
            this.currentSegment = this.nextSegment();
            this.currentSegment.write(super.buffer(), segmentRemain, bufferSize - segmentRemain);
        }
        this.fileOffset += (long)bufferSize;
        super.seek(0L);
    }

    private RandomAccessFile nextSegment() throws IOException {
        File segment;
        if (++this.segmentIndex < this.segments.size()) {
            segment = this.segments.get(this.segmentIndex);
        } else {
            segment = ValueFile.segmentFromId(this.dir, this.segmentIndex);
            this.segments.add(segment);
        }
        if (!segment.exists()) {
            boolean result = segment.createNewFile();
            E.checkState((boolean)result, (String)"Failed to create segment '%s'", (Object[])new Object[]{segment.getAbsolutePath()});
        }
        return new RandomAccessFile(segment, "rw");
    }

    private int currentSegmentRemain() throws IOException {
        long remain = this.maxSegmentSize - this.currentSegment.getFilePointer();
        return (int)remain;
    }
}

