/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.hgkvfile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hugegraph.computer.core.io.BufferedFileOutput;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.AbstractHgkvFile;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.HgkvDir;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.HgkvFile;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.HgkvFileImpl;
import org.apache.hugegraph.computer.core.util.BytesUtil;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.util.E;

public class HgkvDirImpl
extends AbstractHgkvFile
implements HgkvDir {
    public static final String FILE_NAME_PREFIX = "hgkv_";
    public static final String FILE_EXTEND_NAME = ".hgkv";
    private static final String FILE_NAME_REGEX = "hgkv_[0-9]+.hgkv";
    private static final Pattern FILE_NUM_PATTERN = Pattern.compile("[0-9]+");
    private final List<HgkvFile> segments;

    private HgkvDirImpl(String path) {
        this(path, null);
    }

    private HgkvDirImpl(String path, List<HgkvFile> segments) {
        super(path);
        this.segments = segments;
    }

    public static HgkvDir create(String path) throws IOException {
        File file = new File(path);
        E.checkArgument((!file.exists() ? 1 : 0) != 0, (String)"Can't create HgkvDir because the directory already exists: '%s'", (Object[])new Object[]{file.getPath()});
        file.mkdirs();
        return new HgkvDirImpl(path);
    }

    public static HgkvDir open(String path) throws IOException {
        E.checkArgumentNotNull((Object)path, (String)"Parameter path can't be null", (Object[])new Object[0]);
        File file = new File(path);
        E.checkArgument((boolean)file.exists(), (String)"Failed to open path because it does not exists: '%s'", (Object[])new Object[]{file.getPath()});
        E.checkArgument((boolean)file.isDirectory(), (String)"Failed to open path because it's not a directory: '%s'", (Object[])new Object[]{file.getPath()});
        return HgkvDirImpl.open(file);
    }

    private static File[] scanHgkvFiles(File dir) {
        return dir.listFiles((dirName, name) -> name.matches(FILE_NAME_REGEX));
    }

    private static HgkvDir open(File file) throws IOException {
        File[] files = HgkvDirImpl.scanHgkvFiles(file);
        assert (files != null && files.length != 0);
        List<HgkvFile> segments = HgkvDirImpl.segmentsFromFiles(files);
        HgkvDirImpl hgkvDir = new HgkvDirImpl(file.getPath(), segments);
        hgkvDir.build();
        return hgkvDir;
    }

    private static List<HgkvFile> segmentsFromFiles(File[] files) throws IOException {
        ArrayList<HgkvFile> segments = new ArrayList<HgkvFile>();
        for (File file : files) {
            segments.add(HgkvFileImpl.open(file));
        }
        segments.sort((o1, o2) -> {
            int id1 = HgkvDirImpl.fileNameToSegmentId(o1.path());
            int id2 = HgkvDirImpl.fileNameToSegmentId(o2.path());
            return Integer.compare(id1, id2);
        });
        return segments;
    }

    private static int fileNameToSegmentId(String path) {
        String fileName = Paths.get(path, new String[0]).getFileName().toString();
        Matcher matcher = FILE_NUM_PATTERN.matcher(fileName);
        E.checkState((boolean)matcher.find(), (String)"Can't get segment id from illegal file name: '%s'", (Object[])new Object[]{fileName});
        return Integer.parseInt(matcher.group());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public byte[] max() {
        return this.max;
    }

    @Override
    public byte[] min() {
        return this.min;
    }

    @Override
    public List<HgkvFile> segments() {
        return this.segments;
    }

    public BufferedFileOutput output() throws FileNotFoundException {
        throw new NotSupportException("Can't get output from HgkvDir", new Object[0]);
    }

    private void build() throws IOException {
        this.magic = MAGIC;
        this.version = MAJOR_VERSION + "." + MINOR_VERSION;
        this.numEntries = this.segments.stream().mapToLong(HgkvFile::numEntries).sum();
        this.numSubEntries = this.segments.stream().mapToLong(HgkvFile::numSubEntries).sum();
        this.max = this.segments.stream().map(HgkvFile::max).max(BytesUtil::compare).orElse(null);
        this.min = this.segments.stream().map(HgkvFile::min).min(BytesUtil::compare).orElse(null);
        for (HgkvFile segment : this.segments) {
            segment.close();
        }
    }
}

