/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort.sorting;

import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.sort.sorting.HeapInputsSorting;
import org.apache.hugegraph.computer.core.sort.sorting.InputsSorting;
import org.apache.hugegraph.computer.core.sort.sorting.LoserTreeInputsSorting;
import org.apache.hugegraph.computer.core.sort.sorting.SortingMode;

public class SortingFactory {
    private static final SortingMode MODE = SortingMode.LOSER_TREE;

    public static <T> InputsSorting<T> createSorting(List<? extends Iterator<T>> inputs, SortingMode mode) {
        switch (mode) {
            case HEAP: {
                return SortingFactory.createHeapSorting(inputs);
            }
            case LOSER_TREE: {
                return SortingFactory.createLoserTreeSorting(inputs);
            }
        }
        throw new ComputerException("Can't create sorting for '%s'", new Object[]{mode});
    }

    public static <T> InputsSorting<T> createSorting(List<? extends Iterator<T>> inputs) {
        return SortingFactory.createSorting(inputs, MODE);
    }

    private static <T> InputsSorting<T> createLoserTreeSorting(List<? extends Iterator<T>> inputs) {
        return new LoserTreeInputsSorting(inputs);
    }

    private static <T> InputsSorting<T> createHeapSorting(List<? extends Iterator<T>> inputs) {
        return new HeapInputsSorting(inputs);
    }
}

