/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort.flusher;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hugegraph.computer.core.combiner.PointerCombiner;
import org.apache.hugegraph.computer.core.store.entry.DefaultKvEntry;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.store.entry.Pointer;
import org.apache.hugegraph.util.E;

public abstract class CombinableSorterFlusher {
    private final PointerCombiner combiner;

    public CombinableSorterFlusher(PointerCombiner combiner) {
        this.combiner = combiner;
    }

    public void flush(Iterator<KvEntry> entries) throws IOException {
        E.checkArgument((boolean)entries.hasNext(), (String)"Parameter entries can't be empty", (Object[])new Object[0]);
        KvEntry last = entries.next();
        Pointer combineValue = last.value();
        while (true) {
            KvEntry current = null;
            if (entries.hasNext() && last.compareTo(current = entries.next()) == 0) {
                combineValue = this.combiner.combine(combineValue, current.value());
                continue;
            }
            this.writeKvEntry(new DefaultKvEntry(last.key(), combineValue));
            if (current == null) break;
            last = current;
            combineValue = last.value();
        }
    }

    protected abstract void writeKvEntry(KvEntry var1) throws IOException;
}

