/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.sort.flusher.InnerSortFlusher;
import org.apache.hugegraph.computer.core.sort.flusher.OuterSortFlusher;
import org.apache.hugegraph.computer.core.sort.flusher.PeekableIterator;
import org.apache.hugegraph.computer.core.sort.flusher.PeekableIteratorAdaptor;
import org.apache.hugegraph.computer.core.sort.merge.FileMergerImpl;
import org.apache.hugegraph.computer.core.sort.sorter.InputsSorterImpl;
import org.apache.hugegraph.computer.core.sort.sorter.JavaInputSorter;
import org.apache.hugegraph.computer.core.store.EntryIterator;
import org.apache.hugegraph.computer.core.store.KvEntryFileWriter;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.store.file.select.SelectedFiles;

public class DefaultSorter {
    private final Config config;

    public DefaultSorter(Config config) {
        this.config = config;
    }

    public void sortBuffer(EntryIterator entries, InnerSortFlusher flusher) throws Exception {
        JavaInputSorter sorter = new JavaInputSorter();
        flusher.flush(sorter.sort((Iterator<KvEntry>)((Object)entries)));
    }

    public void mergeBuffers(List<EntryIterator> entries, KvEntryFileWriter writer, OuterSortFlusher flusher) throws IOException {
        InputsSorterImpl sorter = new InputsSorterImpl();
        EntryIterator result = sorter.sort(entries);
        flusher.flush(result, writer);
    }

    public void mergeFile(List<SelectedFiles> selectedFiles, Function<String, EntryIterator> fileToEntries, Function<String, KvEntryFileWriter> fileToWriter, OuterSortFlusher flusher) throws Exception {
        FileMergerImpl merger = new FileMergerImpl(this.config);
        for (SelectedFiles select : selectedFiles) {
            merger.merge(select.inputs(), fileToEntries, select.output(), fileToWriter, flusher);
        }
    }

    public PeekableIterator<KvEntry> iterator(List<String> inputs, Function<String, EntryIterator> fileToEntries) throws IOException {
        List<EntryIterator> entries = inputs.stream().map(fileToEntries).collect(Collectors.toList());
        InputsSorterImpl sorter = new InputsSorterImpl();
        return PeekableIteratorAdaptor.of(sorter.sort(entries));
    }
}

