/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sender;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.receiver.MessageStat;
import org.apache.hugegraph.computer.core.sender.WriteBuffers;

public class MessageSendPartition {
    private final ComputerContext context;
    private final int threshold;
    private final int capacity;
    private final Map<Thread, WriteBuffers> buffers;

    public MessageSendPartition(ComputerContext context, int threshold, int capacity) {
        this.context = context;
        this.threshold = threshold;
        this.capacity = capacity;
        this.buffers = new ConcurrentHashMap<Thread, WriteBuffers>();
    }

    public WriteBuffers buffersForCurrentThread() {
        Thread current = Thread.currentThread();
        WriteBuffers buffer = this.buffers.get(current);
        if (buffer == null) {
            buffer = new WriteBuffers(this.context, this.threshold, this.capacity);
            this.buffers.put(current, buffer);
        }
        return buffer;
    }

    public synchronized void clear() {
        this.buffers.clear();
    }

    public synchronized void resetMessageWritten() {
        for (WriteBuffers buffer : this.buffers.values()) {
            buffer.resetMessageWritten();
        }
    }

    public synchronized MessageStat messageWritten() {
        MessageStat partitionStat = new MessageStat();
        for (WriteBuffers buffer : this.buffers.values()) {
            partitionStat.increase(buffer.messageWritten());
        }
        return partitionStat;
    }

    public Collection<WriteBuffers> buffers() {
        return this.buffers.values();
    }
}

