/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import org.apache.hugegraph.computer.core.io.UnsafeBytesOutput;
import org.apache.hugegraph.util.E;

public abstract class AbstractBufferedFileOutput
extends UnsafeBytesOutput {
    private final int bufferCapacity;
    protected long fileOffset;

    public AbstractBufferedFileOutput(int bufferCapacity) {
        super(bufferCapacity);
        this.bufferCapacity = bufferCapacity;
        this.fileOffset = 0L;
    }

    @Override
    public void writeFixedInt(long position, int v) throws IOException {
        if (this.fileOffset <= position && position <= this.position() - 4L) {
            super.writeFixedInt(position - this.fileOffset, v);
            return;
        }
        long latestPosition = this.position();
        this.seek(position);
        super.writeInt(v);
        this.seek(latestPosition);
    }

    @Override
    public long position() {
        return this.fileOffset + super.position();
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        E.checkArgument((bytesToSkip >= 0L ? 1 : 0) != 0, (String)"The parameter bytesToSkip must be >= 0, but got %s", (Object[])new Object[]{bytesToSkip});
        long positionBeforeSkip = this.position();
        this.seek(positionBeforeSkip + bytesToSkip);
        return positionBeforeSkip;
    }

    @Override
    protected void require(int size) throws IOException {
        E.checkArgument((size <= this.bufferCapacity ? 1 : 0) != 0, (String)"The parameter size must be <= %s", (Object[])new Object[]{this.bufferCapacity});
        if (size <= this.bufferAvailable()) {
            return;
        }
        this.flushBuffer();
        if (size > this.bufferAvailable()) {
            throw new IOException(String.format("Write %s bytes to position %s overflows buffer %s", size, this.position(), this.bufferCapacity));
        }
    }

    protected int bufferSize() {
        return (int)super.position();
    }

    protected int bufferAvailable() {
        return this.bufferCapacity - (int)super.position();
    }

    protected int bufferCapacity() {
        return this.bufferCapacity;
    }

    protected abstract void flushBuffer() throws IOException;
}

