/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hugegraph.computer.core.common.SerialEnum;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.edge.DefaultEdge;
import org.apache.hugegraph.computer.core.graph.edge.DefaultEdges;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.edge.Edges;
import org.apache.hugegraph.computer.core.graph.id.BytesId;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.properties.DefaultProperties;
import org.apache.hugegraph.computer.core.graph.properties.Properties;
import org.apache.hugegraph.computer.core.graph.value.BooleanValue;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.FloatValue;
import org.apache.hugegraph.computer.core.graph.value.IdList;
import org.apache.hugegraph.computer.core.graph.value.IdListList;
import org.apache.hugegraph.computer.core.graph.value.IdSet;
import org.apache.hugegraph.computer.core.graph.value.IntValue;
import org.apache.hugegraph.computer.core.graph.value.ListValue;
import org.apache.hugegraph.computer.core.graph.value.LongValue;
import org.apache.hugegraph.computer.core.graph.value.MapValue;
import org.apache.hugegraph.computer.core.graph.value.NullValue;
import org.apache.hugegraph.computer.core.graph.value.StringValue;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.graph.vertex.DefaultVertex;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;

public final class BuiltinGraphFactory
implements GraphFactory {
    private static final int AVERAGE_DEGREE = 10;

    public Id createId() {
        return new BytesId();
    }

    public Id createId(long id) {
        return BytesId.of(id);
    }

    public Id createId(String id) {
        return BytesId.of(id);
    }

    public Id createId(UUID id) {
        return BytesId.of(id);
    }

    public Vertex createVertex() {
        return new DefaultVertex(this);
    }

    public <V extends Value> Vertex createVertex(Id id, V value) {
        return new DefaultVertex(this, id, value);
    }

    public <V extends Value> Vertex createVertex(String label, Id id, V value) {
        return new DefaultVertex(this, label, id, value);
    }

    public Edges createEdges() {
        return this.createEdges(10);
    }

    public Edges createEdges(int capacity) {
        return new DefaultEdges(this, capacity);
    }

    public Edge createEdge() {
        return new DefaultEdge(this);
    }

    public Edge createEdge(Id targetId) {
        return new DefaultEdge(this, "", "", targetId);
    }

    public Edge createEdge(String label, Id targetId) {
        return new DefaultEdge(this, label, "", targetId);
    }

    public Edge createEdge(String label, String name, Id targetId) {
        return new DefaultEdge(this, label, name, targetId);
    }

    public <V> List<V> createList() {
        return new ArrayList();
    }

    public <V> List<V> createList(int capacity) {
        return new ArrayList(capacity);
    }

    public <V> Set<V> createSet() {
        return new HashSet();
    }

    public <V> Set<V> createSet(int capacity) {
        return new HashSet(capacity);
    }

    public <K, V> Map<K, V> createMap() {
        return new HashMap();
    }

    public Properties createProperties() {
        return new DefaultProperties((GraphFactory)this);
    }

    public Value createValue(byte code) {
        ValueType type = (ValueType)SerialEnum.fromCode(ValueType.class, (byte)code);
        return this.createValue(type);
    }

    public Value createValue(ValueType type) {
        switch (type) {
            case NULL: {
                return NullValue.get();
            }
            case BOOLEAN: {
                return new BooleanValue();
            }
            case INT: {
                return new IntValue();
            }
            case LONG: {
                return new LongValue();
            }
            case FLOAT: {
                return new FloatValue();
            }
            case DOUBLE: {
                return new DoubleValue();
            }
            case ID: {
                return new BytesId();
            }
            case ID_LIST: {
                return new IdList();
            }
            case ID_LIST_LIST: {
                return new IdListList();
            }
            case ID_SET: {
                return new IdSet();
            }
            case LIST_VALUE: {
                return new ListValue();
            }
            case MAP_VALUE: {
                return new MapValue();
            }
            case STRING: {
                return new StringValue();
            }
        }
        throw new ComputerException("Can't create Value for %s", new Object[]{type.name()});
    }
}

