/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.aggregator;

import org.apache.hugegraph.computer.core.aggregator.Aggregator;
import org.apache.hugegraph.computer.core.combiner.Combiner;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.FloatValue;
import org.apache.hugegraph.computer.core.graph.value.IntValue;
import org.apache.hugegraph.computer.core.graph.value.LongValue;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.util.E;

public class DefaultAggregator<V extends Value>
implements Aggregator<V> {
    private final ValueType type;
    private final Class<? extends Combiner<V>> combinerClass;
    private transient Combiner<V> combiner;
    private transient ThreadLocal<V> localValue;
    private V value;

    public DefaultAggregator(ComputerContext context, ValueType type, Class<? extends Combiner<V>> combinerClass, V defaultValue) {
        E.checkArgument((type != null ? 1 : 0) != 0, (String)"The value type of aggregator can't be null", (Object[])new Object[0]);
        E.checkArgument((combinerClass != null ? 1 : 0) != 0, (String)"The combiner of aggregator can't be null", (Object[])new Object[0]);
        this.type = type;
        this.combinerClass = combinerClass;
        if (defaultValue != null) {
            this.checkValue(defaultValue);
        }
        this.value = defaultValue;
        if (context != null) {
            this.repair(context);
        }
        E.checkArgument((this.value != null ? 1 : 0) != 0, (String)"Must provide default value for aggregator", (Object[])new Object[0]);
    }

    public void aggregateValue(V value) {
        this.checkValue(value);
        this.combiner.combine(value, this.value, this.value);
    }

    public void aggregateValue(int value) {
        assert (this.type == ValueType.INT);
        Value localValue = (Value)this.localValue.get();
        ((IntValue)localValue).value(value);
        this.combineAndSwapIfNeeded(localValue, this.value);
    }

    public void aggregateValue(long value) {
        assert (this.type == ValueType.LONG);
        Value localValue = (Value)this.localValue.get();
        ((LongValue)localValue).value(value);
        this.combineAndSwapIfNeeded(localValue, this.value);
    }

    public void aggregateValue(float value) {
        assert (this.type == ValueType.FLOAT);
        Value localValue = (Value)this.localValue.get();
        ((FloatValue)localValue).value(value);
        this.combineAndSwapIfNeeded(localValue, this.value);
    }

    public void aggregateValue(double value) {
        assert (this.type == ValueType.DOUBLE);
        Value localValue = (Value)this.localValue.get();
        ((DoubleValue)localValue).value(value);
        this.combineAndSwapIfNeeded(localValue, this.value);
    }

    private void combineAndSwapIfNeeded(V localValue, V thisValue) {
        this.combiner.combine(localValue, thisValue, thisValue);
        localValue.assign(thisValue);
    }

    public V aggregatedValue() {
        assert (this.value != null);
        return this.value;
    }

    public void aggregatedValue(V value) {
        this.checkValue(value);
        this.value = value;
    }

    private void checkValue(V value) {
        E.checkNotNull(value, (String)"aggregator", (String)"value");
        E.checkArgument((value.valueType() == this.type ? 1 : 0) != 0, (String)"Can't set %s value '%s' to %s aggregator", (Object[])new Object[]{value.valueType().string(), value, this.type.string()});
    }

    public String toString() {
        return this.value.toString();
    }

    public Aggregator<V> copy() {
        DefaultAggregator<V> aggregator = new DefaultAggregator<V>(null, this.type, this.combinerClass, this.value);
        Value deepCopyValue = this.value.copy();
        aggregator.value = deepCopyValue;
        aggregator.combiner = this.combiner;
        aggregator.localValue = this.localValue;
        return aggregator;
    }

    public void repair(ComputerContext context) {
        try {
            this.combiner = this.combinerClass.newInstance();
        }
        catch (Exception e) {
            throw new ComputerException("Can't new instance from class: %s", (Throwable)e, new Object[]{this.combinerClass.getName()});
        }
        this.localValue = ThreadLocal.withInitial(() -> this.newValue(context));
        if (this.value == null) {
            this.value = this.newValue(context);
        }
    }

    private V newValue(ComputerContext context) {
        Value val = context.graphFactory().createValue(this.type);
        return (V)val;
    }
}

