/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.value;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.SerialEnum;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.util.E;

public class MapValue<T extends Value>
implements Value {
    private final GraphFactory graphFactory = ComputerContext.instance().graphFactory();
    private ValueType elemType;
    private Map<Id, T> map;

    public MapValue() {
        this(ValueType.UNKNOWN);
    }

    public MapValue(ValueType elemType) {
        this(elemType, new HashMap());
    }

    public MapValue(ValueType elemType, Map<Id, T> map) {
        this.elemType = elemType;
        this.map = map;
    }

    public void put(Id id, T value) {
        E.checkArgument((id != null ? 1 : 0) != 0, (String)"Can't add null key to %s", (Object[])new Object[]{this.valueType().string()});
        E.checkArgument((value != null ? 1 : 0) != 0, (String)"Can't add null value to %s", (Object[])new Object[]{this.valueType().string()});
        if (this.elemType != ValueType.UNKNOWN) {
            E.checkArgument((this.elemType == value.valueType() ? 1 : 0) != 0, (String)"Invalid value '%s' with type %s, expect element with type %s", (Object[])new Object[]{value, value.valueType().string(), this.elemType.string()});
        } else {
            this.elemType = value.valueType();
        }
        this.map.put(id, value);
    }

    public T get(Id id) {
        return (T)((Value)this.map.get(id));
    }

    public Set<Map.Entry<Id, T>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public ValueType valueType() {
        return ValueType.MAP_VALUE;
    }

    @Override
    public void assign(Value other) {
        this.checkAssign(other);
        ValueType elemType = ((MapValue)other).elemType();
        E.checkArgument((elemType == this.elemType() ? 1 : 0) != 0, (String)"Can't assign %s<%s> to %s<%s>", (Object[])new Object[]{other.valueType().string(), elemType.string(), this.valueType().string(), this.elemType().string()});
        this.map = ((MapValue)other).map;
    }

    public ValueType elemType() {
        return this.elemType;
    }

    @Override
    public Value copy() {
        HashMap<Id, Value> map = new HashMap<Id, Value>();
        for (Map.Entry<Id, T> entry : this.map.entrySet()) {
            map.put(entry.getKey(), ((Value)entry.getValue()).copy());
        }
        return new MapValue(this.elemType, map);
    }

    @Override
    public Object value() {
        return this.map;
    }

    @Override
    public void read(RandomAccessInput in) throws IOException {
        this.read(in, true);
    }

    protected void read(RandomAccessInput in, boolean readElemType) throws IOException {
        int size = in.readInt();
        if (readElemType) {
            this.elemType = SerialEnum.fromCode(ValueType.class, in.readByte());
        }
        this.map = this.graphFactory.createMap();
        for (int i = 0; i < size; ++i) {
            Id id = this.graphFactory.createId();
            id.read(in);
            Value value = this.graphFactory.createValue(this.elemType);
            value.read(in);
            this.map.put(id, value);
        }
    }

    @Override
    public void write(RandomAccessOutput out) throws IOException {
        this.write(out, true);
    }

    protected void write(RandomAccessOutput out, boolean writeElemType) throws IOException {
        out.writeInt(this.map.size());
        if (writeElemType) {
            out.writeByte(this.elemType.code());
        }
        for (Map.Entry<Id, T> entry : this.map.entrySet()) {
            Id id = entry.getKey();
            Value value = (Value)entry.getValue();
            id.write(out);
            value.write(out);
        }
    }

    @Override
    public int compareTo(Value obj) {
        throw new UnsupportedOperationException("MapValue.compareTo()");
    }

    @Override
    public String string() {
        return "MapValue{elemType=" + this.elemType + ", map=" + this.map + "}";
    }
}

