/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.value;

import java.io.IOException;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.util.E;

public class BooleanValue
implements Value.Tvalue<Boolean> {
    private boolean value;

    public BooleanValue() {
        this(false);
    }

    public BooleanValue(boolean value) {
        this.value = value;
    }

    public boolean boolValue() {
        return this.value;
    }

    @Override
    public Boolean value() {
        return this.value;
    }

    public void value(boolean value) {
        this.value = value;
    }

    @Override
    public ValueType valueType() {
        return ValueType.BOOLEAN;
    }

    @Override
    public void assign(Value other) {
        this.checkAssign(other);
        this.value = ((BooleanValue)other).value;
    }

    @Override
    public BooleanValue copy() {
        return new BooleanValue(this.value);
    }

    @Override
    public void read(RandomAccessInput in) throws IOException {
        this.value = in.readBoolean();
    }

    @Override
    public void write(RandomAccessOutput out) throws IOException {
        out.writeBoolean(this.value);
    }

    @Override
    public int compareTo(Value obj) {
        E.checkArgumentNotNull((Object)obj, (String)"The compare argument can't be null", (Object[])new Object[0]);
        int typeDiff = this.valueType().compareTo(obj.valueType());
        if (typeDiff != 0) {
            return typeDiff;
        }
        return Boolean.compare(this.value, ((BooleanValue)obj).value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BooleanValue)) {
            return false;
        }
        return ((BooleanValue)obj).value == this.value;
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

