/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.disruptor.dsl;

import com.alipay.disruptor.EventHandler;
import com.alipay.disruptor.EventProcessor;
import com.alipay.disruptor.Sequence;
import com.alipay.disruptor.SequenceBarrier;
import com.alipay.disruptor.WorkHandler;
import com.alipay.disruptor.dsl.ConsumerRepository;
import com.alipay.disruptor.dsl.Disruptor;
import com.alipay.disruptor.dsl.EventProcessorFactory;
import java.util.Arrays;

public class EventHandlerGroup<T> {
    private final Disruptor<T> disruptor;
    private final ConsumerRepository<T> consumerRepository;
    private final Sequence[] sequences;

    EventHandlerGroup(Disruptor<T> disruptor, ConsumerRepository<T> consumerRepository, Sequence[] sequences) {
        this.disruptor = disruptor;
        this.consumerRepository = consumerRepository;
        this.sequences = Arrays.copyOf(sequences, sequences.length);
    }

    public EventHandlerGroup<T> and(EventHandlerGroup<T> otherHandlerGroup) {
        Sequence[] combinedSequences = new Sequence[this.sequences.length + otherHandlerGroup.sequences.length];
        System.arraycopy(this.sequences, 0, combinedSequences, 0, this.sequences.length);
        System.arraycopy(otherHandlerGroup.sequences, 0, combinedSequences, this.sequences.length, otherHandlerGroup.sequences.length);
        return new EventHandlerGroup<T>(this.disruptor, this.consumerRepository, combinedSequences);
    }

    public EventHandlerGroup<T> and(EventProcessor ... processors) {
        Sequence[] combinedSequences = new Sequence[this.sequences.length + processors.length];
        for (int i = 0; i < processors.length; ++i) {
            this.consumerRepository.add(processors[i]);
            combinedSequences[i] = processors[i].getSequence();
        }
        System.arraycopy(this.sequences, 0, combinedSequences, processors.length, this.sequences.length);
        return new EventHandlerGroup<T>(this.disruptor, this.consumerRepository, combinedSequences);
    }

    public EventHandlerGroup<T> then(EventHandler<? super T> ... handlers) {
        return this.handleEventsWith(handlers);
    }

    public EventHandlerGroup<T> then(EventProcessorFactory<T> ... eventProcessorFactories) {
        return this.handleEventsWith(eventProcessorFactories);
    }

    public EventHandlerGroup<T> thenHandleEventsWithWorkerPool(WorkHandler<? super T> ... handlers) {
        return this.handleEventsWithWorkerPool(handlers);
    }

    public EventHandlerGroup<T> handleEventsWith(EventHandler<? super T> ... handlers) {
        return this.disruptor.createEventProcessors(this.sequences, handlers);
    }

    public EventHandlerGroup<T> handleEventsWith(EventProcessorFactory<T> ... eventProcessorFactories) {
        return this.disruptor.createEventProcessors(this.sequences, eventProcessorFactories);
    }

    public EventHandlerGroup<T> handleEventsWithWorkerPool(WorkHandler<? super T> ... handlers) {
        return this.disruptor.createWorkerPool(this.sequences, handlers);
    }

    public SequenceBarrier asSequenceBarrier() {
        return this.disruptor.getRingBuffer().newBarrier(this.sequences);
    }
}

