/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class TimeToLiveProcedureWALCleaner
extends BaseLogCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger((String)TimeToLiveProcedureWALCleaner.class.getName());
    public static final String TTL_CONF_KEY = "hbase.master.procedurewalcleaner.ttl";
    public static final long DEFAULT_TTL = 604800000L;
    private long ttl;
    private boolean stopped = false;

    public void setConf(Configuration conf) {
        this.ttl = conf.getLong(TTL_CONF_KEY, 604800000L);
        super.setConf(conf);
    }

    @Override
    public boolean isFileDeletable(FileStatus fStat) {
        if (!MasterProcedureUtil.validateProcedureWALFilename(fStat.getPath().getName())) {
            return true;
        }
        long currentTime = EnvironmentEdgeManager.currentTime();
        long time = fStat.getModificationTime();
        long life = currentTime - time;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Procedure log life:" + life + ", ttl:" + this.ttl + ", current:" + currentTime + ", from: " + time);
        }
        if (life < 0L) {
            LOG.warn("Found a procedure log (" + fStat.getPath() + ") newer than current time (" + currentTime + " < " + time + "), probably a clock skew");
            return false;
        }
        return life > this.ttl;
    }

    public void stop(String why) {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

