/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.util.UnsafeAccess;
import org.apache.yetus.audience.InterfaceAudience;
import sun.misc.Unsafe;

@InterfaceAudience.Private
public class UnsafeSharedMemoryBucketEntry
extends BucketCache.BucketEntry {
    private static final long serialVersionUID = 707544024564058801L;
    private static final Unsafe unsafe = UnsafeAccess.theUnsafe;
    private static final long refCountOffset;
    private volatile boolean markedForEvict;
    private volatile int refCount = 0;

    public UnsafeSharedMemoryBucketEntry(long offset, int length, long accessCounter, boolean inMemory) {
        super(offset, length, accessCounter, inMemory);
    }

    @Override
    protected int getRefCount() {
        return this.refCount;
    }

    @Override
    protected int incrementRefCountAndGet() {
        return unsafe.getAndAddInt(this, refCountOffset, 1) + 1;
    }

    @Override
    protected int decrementRefCountAndGet() {
        return unsafe.getAndAddInt(this, refCountOffset, -1) - 1;
    }

    @Override
    protected boolean isMarkedForEvict() {
        return this.markedForEvict;
    }

    @Override
    protected void markForEvict() {
        this.markedForEvict = true;
    }

    static {
        try {
            refCountOffset = unsafe.objectFieldOffset(UnsafeSharedMemoryBucketEntry.class.getDeclaredField("refCount"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

