/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.centrality.pagerank;

import java.util.Iterator;
import org.apache.hugegraph.computer.core.aggregator.Aggregator;
import org.apache.hugegraph.computer.core.combiner.Combiner;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.LongValue;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;
import org.apache.hugegraph.computer.core.worker.WorkerContext;

public class PageRank
implements Computation<DoubleValue> {
    public static final String OPTION_ALPHA = "page_rank.alpha";
    public static final double ALPHA_DEFAULT_VALUE = 0.15;
    private double alpha;
    private double danglingRank;
    private double initialRankInSuperstep;
    private double cumulativeRank;
    private Aggregator<DoubleValue> l1DiffAggr;
    private Aggregator<DoubleValue> cumulativeRankAggr;
    private Aggregator<LongValue> danglingVertexNumAggr;
    private Aggregator<DoubleValue> danglingCumulativeAggr;
    private DoubleValue initialValue;
    private DoubleValue contribValue;

    public String name() {
        return "page_rank";
    }

    public String category() {
        return "centrality";
    }

    public void compute0(ComputationContext context, Vertex vertex) {
        vertex.value((Value)this.initialValue);
        this.cumulativeRankAggr.aggregateValue(this.initialValue.value().doubleValue());
        int edgeCount = vertex.numEdges();
        if (edgeCount == 0) {
            this.danglingVertexNumAggr.aggregateValue(1L);
            this.danglingCumulativeAggr.aggregateValue(this.initialValue.value().doubleValue());
        } else {
            this.contribValue.value(this.initialValue.value() / (double)edgeCount);
            context.sendMessageToAllEdges(vertex, (Value)this.contribValue);
        }
    }

    public void compute(ComputationContext context, Vertex vertex, Iterator<DoubleValue> messages) {
        DoubleValue message = (DoubleValue)Combiner.combineAll((Combiner)context.combiner(), messages);
        double rankFromNeighbors = 0.0;
        if (message != null) {
            rankFromNeighbors = message.value();
        }
        double rank = (this.danglingRank + rankFromNeighbors) * (1.0 - this.alpha) + this.initialRankInSuperstep;
        DoubleValue oldRank = (DoubleValue)vertex.value();
        vertex.value((Value)new DoubleValue(rank /= this.cumulativeRank));
        this.l1DiffAggr.aggregateValue(Math.abs(oldRank.value() - rank));
        this.cumulativeRankAggr.aggregateValue(rank);
        int edgeCount = vertex.numEdges();
        if (edgeCount == 0) {
            this.danglingVertexNumAggr.aggregateValue(1L);
            this.danglingCumulativeAggr.aggregateValue(rank);
        } else {
            this.contribValue.value(rank / (double)edgeCount);
            context.sendMessageToAllEdges(vertex, (Value)this.contribValue);
        }
    }

    public void init(Config config) {
        this.alpha = config.getDouble(OPTION_ALPHA, 0.15);
        this.contribValue = new DoubleValue();
    }

    public void close(Config config) {
    }

    public void beforeSuperstep(WorkerContext context) {
        DoubleValue danglingTotalRank = (DoubleValue)context.aggregatedValue("pagerank.comulative_dangling_probability");
        DoubleValue cumulativeRank = (DoubleValue)context.aggregatedValue("pagerank.comulative_probability");
        long totalVertex = context.totalVertexCount();
        this.danglingRank = danglingTotalRank.value() / (double)totalVertex;
        this.initialRankInSuperstep = this.alpha / (double)totalVertex;
        this.cumulativeRank = cumulativeRank.value();
        this.initialValue = new DoubleValue(1.0 / (double)totalVertex);
        this.l1DiffAggr = context.createAggregator("pagerank.aggr_l1_norm_difference");
        this.cumulativeRankAggr = context.createAggregator("pagerank.comulative_probability");
        this.danglingVertexNumAggr = context.createAggregator("pagerank.dangling_vertices_num");
        this.danglingCumulativeAggr = context.createAggregator("pagerank.comulative_dangling_probability");
    }

    public void afterSuperstep(WorkerContext context) {
        context.aggregateValue("pagerank.comulative_probability", (Value)((DoubleValue)this.cumulativeRankAggr.aggregatedValue()));
        context.aggregateValue("pagerank.aggr_l1_norm_difference", (Value)((DoubleValue)this.l1DiffAggr.aggregatedValue()));
        context.aggregateValue("pagerank.dangling_vertices_num", (Value)((LongValue)this.danglingVertexNumAggr.aggregatedValue()));
        context.aggregateValue("pagerank.comulative_dangling_probability", (Value)((DoubleValue)this.danglingCumulativeAggr.aggregatedValue()));
    }
}

