/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.centrality.closeness;

import java.io.IOException;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.id.IdFactory;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;

public class ClosenessMessage
implements Value.CustomizeValue<ClosenessMessage> {
    private final GraphFactory graphFactory = ComputerContext.instance().graphFactory();
    private Id senderId;
    private Id startId;
    private DoubleValue distance;

    public ClosenessMessage() {
        this(IdFactory.createId(), IdFactory.createId(), new DoubleValue(0.0));
    }

    public ClosenessMessage(Id senderId, Id startId, DoubleValue distance) {
        this.senderId = senderId;
        this.startId = startId;
        this.distance = distance;
    }

    public Id senderId() {
        return this.senderId;
    }

    public Id startId() {
        return this.startId;
    }

    public DoubleValue distance() {
        return this.distance;
    }

    public ClosenessMessage value() {
        throw new UnsupportedOperationException();
    }

    public void read(RandomAccessInput in) throws IOException {
        this.senderId = this.graphFactory.createId();
        this.senderId.read(in);
        this.startId = this.graphFactory.createId();
        this.startId.read(in);
        this.distance = (DoubleValue)this.graphFactory.createValue(ValueType.DOUBLE);
        this.distance.read(in);
    }

    public void write(RandomAccessOutput out) throws IOException {
        this.senderId.write(out);
        this.startId.write(out);
        this.distance.write(out);
    }
}

