/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.jdbc;

import java.sql.SQLException;
import org.apache.hugegraph.loader.exception.LoadException;
import org.postgresql.core.Utils;

public final class JDBCUtil {
    public static String escapeMysql(String value) {
        int length = value.length();
        if (!JDBCUtil.isEscapeNeededForString(value, length)) {
            return '\'' + value + '\'';
        }
        StringBuilder buf = new StringBuilder((int)((double)length * 1.1));
        buf.append('\'');
        block9: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\u0000': {
                    buf.append('\\');
                    buf.append('0');
                    continue block9;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    continue block9;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    continue block9;
                }
                case '\u001a': {
                    buf.append('\\');
                    buf.append('Z');
                    continue block9;
                }
                case '\"': {
                    buf.append('\"');
                    continue block9;
                }
                case '\'': {
                    buf.append('\\');
                    buf.append('\'');
                    continue block9;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        buf.append('\'');
        return buf.toString();
    }

    public static String escapePostgresql(String value) {
        StringBuilder builder = new StringBuilder(8 + value.length());
        builder.append('\'');
        try {
            Utils.escapeLiteral((StringBuilder)builder, (String)value, (boolean)false);
        }
        catch (SQLException e) {
            throw new LoadException("Failed to escape '%s'", (Throwable)e, value);
        }
        builder.append('\'');
        return builder.toString();
    }

    public static String escapeOracle(String value) {
        return JDBCUtil.escapeMysql(value);
    }

    public static String escapeSqlserver(String value) {
        return JDBCUtil.escapeMysql(value);
    }

    private static boolean isEscapeNeededForString(String sql, int length) {
        boolean needsEscape = false;
        for (int i = 0; i < length; ++i) {
            char c = sql.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': 
                case '\u001a': 
                case '\'': 
                case '\\': {
                    needsEscape = true;
                    break;
                }
            }
            if (needsEscape) break;
        }
        return needsEscape;
    }
}

