/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.metrics;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hugegraph.loader.mapping.EdgeMapping;
import org.apache.hugegraph.loader.mapping.ElementMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.mapping.VertexMapping;
import org.apache.spark.SparkContext;
import org.apache.spark.util.LongAccumulator;

public final class LoadDistributeMetrics
implements Serializable {
    private final InputStruct struct;
    private final Map<String, Metrics> vertexDisMetrics;
    private final Map<String, Metrics> edgeDisMetrics;

    public LoadDistributeMetrics(InputStruct struct) {
        this.struct = struct;
        this.vertexDisMetrics = new HashMap<String, Metrics>();
        this.edgeDisMetrics = new HashMap<String, Metrics>();
        for (VertexMapping vertexMapping : struct.vertices()) {
            this.vertexDisMetrics.put(vertexMapping.label(), new Metrics());
        }
        for (EdgeMapping edgeMapping : struct.edges()) {
            this.edgeDisMetrics.put(edgeMapping.label(), new Metrics());
        }
    }

    public void init(SparkContext sc) {
        Metrics metrics;
        for (VertexMapping vertexMapping : this.struct.vertices()) {
            metrics = this.vertexDisMetrics.get(vertexMapping.label());
            metrics.insertSuccess = sc.longAccumulator(vertexMapping.label() + "_" + "insert");
            metrics.parseSuccess = sc.longAccumulator(vertexMapping.label() + "_" + "parse");
        }
        for (EdgeMapping edgeMapping : this.struct.edges()) {
            metrics = this.edgeDisMetrics.get(edgeMapping.label());
            metrics.insertSuccess = sc.longAccumulator(edgeMapping.label() + "_" + "insert");
            metrics.parseSuccess = sc.longAccumulator(edgeMapping.label() + "_" + "parse");
        }
    }

    public void increaseDisVertexParseSuccess(ElementMapping mapping) {
        this.disMetrics(mapping).parseSuccess.add(1L);
    }

    public void pluseDisVertexParseSuccess(ElementMapping mapping, Long count) {
        this.disMetrics(mapping).parseSuccess.add(count);
    }

    public void increaseDisVertexInsertSuccess(ElementMapping mapping) {
        this.disMetrics(mapping).insertSuccess.add(1L);
    }

    public void plusDisVertexInsertSuccess(ElementMapping mapping, Long count) {
        this.disMetrics(mapping).insertSuccess.add(count);
    }

    public void increaseDisEdgeParseSuccess(ElementMapping mapping) {
        this.disMetrics(mapping).parseSuccess.add(1L);
    }

    public void pluseDisEdgeParseSuccess(ElementMapping mapping, Long count) {
        this.disMetrics(mapping).parseSuccess.add(count);
    }

    public void increaseDisEdgeInsertSuccess(ElementMapping mapping) {
        this.disMetrics(mapping).insertSuccess.add(1L);
    }

    public void plusDisEdgeInsertSuccess(ElementMapping mapping, Long count) {
        this.disMetrics(mapping).insertSuccess.add(count);
    }

    public Long readVertexInsertSuccess() {
        long totalCnt = 0L;
        Collection<Metrics> values = this.vertexDisMetrics.values();
        for (Metrics metrics : values) {
            totalCnt += metrics.insertSuccess();
        }
        return totalCnt;
    }

    public Long readEdgeInsertSuccess() {
        long totalCnt = 0L;
        Collection<Metrics> values = this.edgeDisMetrics.values();
        for (Metrics metrics : values) {
            totalCnt += metrics.insertSuccess();
        }
        return totalCnt;
    }

    private Metrics disMetrics(ElementMapping mapping) {
        if (mapping.type().isVertex()) {
            return this.vertexDisMetrics.get(mapping.label());
        }
        return this.edgeDisMetrics.get(mapping.label());
    }

    public static class Metrics
    implements Serializable {
        private LongAccumulator parseSuccess;
        private LongAccumulator parseFailure;
        private LongAccumulator insertSuccess;
        private LongAccumulator insertFailure;

        public long parseSuccess() {
            return this.parseSuccess.value();
        }

        public long parseFailure() {
            return this.parseFailure.value();
        }

        public long insertSuccess() {
            return this.insertSuccess.value();
        }

        public long insertFailure() {
            return this.insertFailure.value();
        }
    }
}

