/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.crd.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CommonComponentState {
    NOT_READY("NotReady"),
    READY("Ready"),
    DELETED("Deleted");

    private final String value;
    private static final Map<String, CommonComponentState> CONSTANTS;

    private CommonComponentState(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static CommonComponentState fromValue(String value) {
        CommonComponentState constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, CommonComponentState>();
        for (CommonComponentState c : CommonComponentState.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

