/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.value;

import java.io.IOException;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.util.E;

public class DoubleValue
extends Number
implements Value.Tvalue<Double> {
    private static final long serialVersionUID = -524902178200973565L;
    private double value;

    public DoubleValue() {
        this(0.0);
    }

    public DoubleValue(double value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Double value() {
        return this.value;
    }

    public void value(double value) {
        this.value = value;
    }

    @Override
    public ValueType valueType() {
        return ValueType.DOUBLE;
    }

    @Override
    public void assign(Value other) {
        this.checkAssign(other);
        this.value = ((DoubleValue)other).value;
    }

    @Override
    public DoubleValue copy() {
        return new DoubleValue(this.value);
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public void read(RandomAccessInput in) throws IOException {
        this.value = in.readDouble();
    }

    @Override
    public void write(RandomAccessOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    @Override
    public int compareTo(Value obj) {
        E.checkArgumentNotNull(obj, "The compare argument can't be null", new Object[0]);
        int typeDiff = this.valueType().compareTo(obj.valueType());
        if (typeDiff != 0) {
            return typeDiff;
        }
        return Double.compare(this.value, ((DoubleValue)obj).value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleValue)) {
            return false;
        }
        return ((DoubleValue)obj).value == this.value;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

