/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.graph;

import com.google.common.collect.ImmutableMap;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.exception.NotAllCreatedException;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.structure.graph.BatchEdgeRequest;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Edges;

public class EdgeAPI
extends GraphAPI {
    public EdgeAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.EDGE.string();
    }

    public Edge create(Edge edge) {
        RestResult result = this.client.post(this.path(), edge);
        return result.readObject(Edge.class);
    }

    public List<String> create(List<Edge> edges, boolean checkVertex) {
        MultivaluedHashMap<String, Object> headers = new MultivaluedHashMap<String, Object>();
        headers.putSingle("Content-Encoding", "gzip");
        ImmutableMap<String, Object> params = ImmutableMap.of("check_vertex", checkVertex);
        RestResult result = this.client.post(this.batchPath(), edges, headers, params);
        List<String> ids = result.readList(String.class);
        if (edges.size() != ids.size()) {
            throw new NotAllCreatedException("Not all edges are successfully created, expect '%s', the actual is '%s'", ids, edges.size(), ids.size());
        }
        return ids;
    }

    public List<Edge> update(BatchEdgeRequest request) {
        this.client.checkApiVersion("0.45", "batch property update");
        MultivaluedHashMap<String, Object> headers = new MultivaluedHashMap<String, Object>();
        headers.putSingle("Content-Encoding", "gzip");
        RestResult result = this.client.put(this.batchPath(), (String)null, (Object)request, (MultivaluedMap<String, Object>)headers);
        return result.readList(this.type(), Edge.class);
    }

    public Edge append(Edge edge) {
        String id = edge.id();
        ImmutableMap<String, Object> params = ImmutableMap.of("action", "append");
        RestResult result = this.client.put(this.path(), id, (Object)edge, params);
        return result.readObject(Edge.class);
    }

    public Edge eliminate(Edge edge) {
        String id = edge.id();
        ImmutableMap<String, Object> params = ImmutableMap.of("action", "eliminate");
        RestResult result = this.client.put(this.path(), id, (Object)edge, params);
        return result.readObject(Edge.class);
    }

    public Edge get(String id) {
        RestResult result = this.client.get(this.path(), id);
        return result.readObject(Edge.class);
    }

    public Edges list(int limit) {
        return this.list(null, null, null, null, 0, null, limit);
    }

    public Edges list(Object vertexId, Direction direction, String label, Map<String, Object> properties, int offset, String page, int limit) {
        return this.list(vertexId, direction, label, properties, false, offset, page, limit);
    }

    public Edges list(Object vertexId, Direction direction, String label, Map<String, Object> properties, boolean keepP, int offset, String page, int limit) {
        EdgeAPI.checkOffset(offset);
        EdgeAPI.checkLimit(limit, "Limit");
        String vid = GraphAPI.formatVertexId(vertexId, true);
        String props = GraphAPI.formatProperties(properties);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("vertex_id", vid);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("properties", props);
        params.put("keep_start_p", keepP);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("page", page);
        RestResult result = this.client.get(this.path(), params);
        return result.readObject(Edges.class);
    }

    public void delete(String id) {
        this.client.delete(this.path(), id);
    }
}

